/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.lifecycle;

import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.threading.ThreadMutex;

public abstract class AbstractLifeCycle
extends LoggedObject
implements LifeCycle {
    private boolean isRunning = false;
    private final ThreadMutex runLock = new ThreadMutex();

    protected abstract void begin();

    protected abstract void end();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        ThreadMutex threadMutex = this.runLock;
        synchronized (threadMutex) {
            if (this.isRunning) {
                this.getLogger().info("Is already started");
                return;
            }
            this.begin();
            this.isRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        ThreadMutex threadMutex = this.runLock;
        synchronized (threadMutex) {
            this.isRunning = false;
            this.end();
        }
    }
}

