/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.layout.tablelayout;

import com.schneide.base.layout.tablelayout.TableColumn;
import com.schneide.base.layout.tablelayout.TableLine;
import com.schneide.base.layout.tablelayout.TableLineHolder;
import com.schneide.base.layout.tablelayout.TableRow;
import com.schneide.base.logging.LoggedObject;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;

public class TableSpecification
extends LoggedObject {
    private final TableLineHolder columnsHolder = new TableLineHolder();
    private final TableLineHolder rowsHolder = new TableLineHolder();

    public TableSpecification(String columns, String rows) {
        this.columnsHolder.addLines(this.parseTableColumns(columns));
        this.rowsHolder.addLines(this.parseTableRows(rows));
    }

    public double[] getRowSizes() {
        return this.rowsHolder.getLineSizes();
    }

    public double[] getColumnSizes() {
        return this.columnsHolder.getLineSizes();
    }

    public int getRowIndexWithSpacerRows(int indexWithoutSpacers) {
        return this.getRowIndexWithSpacerRows(indexWithoutSpacers, 0);
    }

    public int getRowIndexWithSpacerRows(int indexWithoutSpacers, int internalOffset) {
        return this.getLineIndexWithSpacerLines(this.rowsHolder, indexWithoutSpacers, internalOffset);
    }

    public int getColumnIndexWithSpacerColumns(int indexWithoutSpacers) {
        return this.getColumnIndexWithSpacerColumns(indexWithoutSpacers, 0);
    }

    public int getColumnIndexWithSpacerColumns(int indexWithoutSpacers, int internalOffset) {
        return this.getLineIndexWithSpacerLines(this.columnsHolder, indexWithoutSpacers, internalOffset);
    }

    private int getLineIndexWithSpacerLines(TableLineHolder lineHolder, int indexWithoutSpacers, int internalOffset) {
        return lineHolder.getRealLineIndex(indexWithoutSpacers, internalOffset);
    }

    private TableLine[] parseTableRows(String rowsSpecification) {
        return this.parseTableLines(rowsSpecification, TableRow.class);
    }

    private TableLine[] parseTableColumns(String columnsSpecification) {
        return this.parseTableLines(columnsSpecification, TableColumn.class);
    }

    private TableLine[] parseTableLines(String linesSpecification, Class<? extends Object> lineTypeClass) {
        try {
            Constructor<? extends Object> tableLineConstructor = lineTypeClass.getConstructor(String.class);
            StringTokenizer tokenizer = new StringTokenizer(linesSpecification, ":;, ");
            TableLine[] result = new TableLine[tokenizer.countTokens()];
            for (int i = 0; i < result.length; ++i) {
                try {
                    result[i] = (TableLine)tableLineConstructor.newInstance(tokenizer.nextToken());
                    continue;
                }
                catch (Exception e) {
                    this.getLogger().error("Failure in creating table line indexed " + i, e);
                }
            }
            return result;
        }
        catch (Exception e) {
            this.getLogger().error("Failure in creating table lines", e);
            return new TableLine[0];
        }
    }
}

