/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.layout.tablelayout;

import com.schneide.base.logging.LoggedObject;

public class TableLineSpecificationInterpreter
extends LoggedObject {
    private static final char[] BORDER_IDENTIFIERS = new char[]{'(', '[', '{', '<', '/', '\\', '#', '|', ')', ']', '}', '>'};
    private final double size;
    private boolean isSpacer;

    public TableLineSpecificationInterpreter(String specfication) {
        String cleanSpecification = this.parseSpacerLayer(specfication.trim());
        this.size = this.parseSize(cleanSpecification);
    }

    private double parseSize(String element) {
        if (Character.isDigit(element.charAt(0))) {
            return this.parseNumericSize(element);
        }
        return this.parseSymbolicSize(element);
    }

    private double parseSymbolicSize(String toParse) {
        if ("PREFERRED".equalsIgnoreCase(toParse)) {
            return -2.0;
        }
        if ("FILL".equalsIgnoreCase(toParse)) {
            return -1.0;
        }
        if ("MINIMUM".equalsIgnoreCase(toParse)) {
            return -3.0;
        }
        return -1.0;
    }

    private double parseNumericSize(String toParse) {
        double result = 1.0;
        String reallyToParse = toParse;
        if (toParse.endsWith("%")) {
            reallyToParse = toParse.substring(0, toParse.length() - 1);
            result = 0.01;
        }
        try {
            result *= Double.parseDouble(reallyToParse);
        }
        catch (NumberFormatException e) {
            this.getLogger().error("Could not parse to a number (double type): " + reallyToParse, e);
        }
        return result;
    }

    private String parseSpacerLayer(String specification) {
        this.isSpacer = this.hasSpacerChars(specification);
        if (!this.isSpacer) {
            return specification;
        }
        char[] characters = specification.toCharArray();
        StringBuffer cleanSpecification = new StringBuffer();
        for (char element : characters) {
            if (this.isSpacerChar(element)) continue;
            cleanSpecification.append(element);
        }
        return cleanSpecification.toString();
    }

    private boolean isSpacerChar(char character) {
        for (char element : BORDER_IDENTIFIERS) {
            if (character != element) continue;
            return true;
        }
        return false;
    }

    private boolean hasSpacerChars(String specification) {
        String[] spacerChars;
        for (String element : spacerChars = TableLineSpecificationInterpreter.getBorderIdentifierStrings()) {
            if (!specification.startsWith(element)) continue;
            return true;
        }
        return false;
    }

    private static String[] getBorderIdentifierStrings() {
        String[] result = new String[BORDER_IDENTIFIERS.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = String.valueOf(BORDER_IDENTIFIERS[i]);
        }
        return result;
    }

    public boolean isSpacer() {
        return this.isSpacer;
    }

    public double getSize() {
        return this.size;
    }
}

