/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.layout.tablelayout;

import com.schneide.base.layout.tablelayout.StringTableLayoutConstraint;
import com.schneide.base.layout.tablelayout.TableSpecification;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import info.clearthought.layout.TableLayoutConstraints;

public class GenericStringTableLayoutConstraint
implements StringTableLayoutConstraint {
    private final TableSpecification specification;
    private int xpos;
    private int ypos;
    private int width;
    private int height;
    private String hAlign;
    private String vAlign;

    public GenericStringTableLayoutConstraint(TableSpecification specification) {
        this.specification = specification;
        this.width = 1;
        this.height = 1;
        this.hAlign = "FULL";
        this.vAlign = "FULL";
    }

    @Override
    public TableSpecification getSpecification() {
        return this.specification;
    }

    public TableLayoutConstraints getTableConstraints() {
        int xpos2 = this.getSpecification().getColumnIndexWithSpacerColumns(this.getWidth() - 1, this.getXpos());
        int ypos2 = this.getSpecification().getRowIndexWithSpacerRows(this.getHeight() - 1, this.getYpos());
        DirectChunkBuffer constraints = new DirectChunkBuffer(", ");
        constraints.append(this.getXpos());
        constraints.append(this.getYpos());
        constraints.append(xpos2);
        constraints.append(ypos2);
        constraints.append(this.getHAlign());
        constraints.append(this.getVAlign());
        return new TableLayoutConstraints(constraints.toString());
    }

    @Override
    public String getHAlign() {
        return this.hAlign;
    }

    @Override
    public void setHAlign(String align) {
        this.hAlign = align;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public String getVAlign() {
        return this.vAlign;
    }

    @Override
    public void setVAlign(String align) {
        this.vAlign = align;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getXpos() {
        return this.xpos;
    }

    @Override
    public void setXpos(int xpos) {
        this.xpos = xpos;
    }

    @Override
    public int getYpos() {
        return this.ypos;
    }

    @Override
    public void setYpos(int ypos) {
        this.ypos = ypos;
    }
}

