/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.layout;

import com.schneide.base.layout.ParseContext;
import java.awt.Insets;

public class StringInsets
extends Insets {
    private static final long serialVersionUID = 6066126109613401820L;

    public StringInsets() {
        this(0, 0, 0, 0);
    }

    public StringInsets(Insets oldInsets) {
        this(oldInsets.top, oldInsets.left, oldInsets.bottom, oldInsets.right);
    }

    public StringInsets(String parameters) {
        this();
        this.setValues(parameters);
    }

    private StringInsets(int top, int left, int bottom, int right) {
        super(top, left, bottom, right);
    }

    public void setValues(String values) {
        if (values == null) {
            return;
        }
        char[] chars = this.normalizeString(values);
        ParseContext context = new ParseContext(chars);
        while (!context.isDone()) {
            this.parseOneValue(context);
        }
        if (!context.isNamedValueSeen() && !context.isUnnamedValueSeen()) {
            throw new IllegalArgumentException("Insets: No values specified");
        }
        if (!context.isNamedValueSeen() && !context.edgesSeen()) {
            throw new IllegalArgumentException("Insets: When using unnamed values, four values must be specified");
        }
    }

    private char[] normalizeString(String string) {
        boolean changed = false;
        int i = 0;
        char[] chars = string.toCharArray();
        boolean charSeen = false;
        boolean openBracketSeen = false;
        boolean closeBracketSeen = false;
        for (int j = 0; j < chars.length; ++j) {
            char oneChar = chars[j];
            if (Character.isWhitespace(oneChar)) {
                changed = true;
                continue;
            }
            if (oneChar == '[') {
                if (openBracketSeen) {
                    throw new IllegalArgumentException("Insets: Only one '[' allowed");
                }
                changed = true;
                openBracketSeen = true;
                if (!charSeen) continue;
                throw new IllegalArgumentException("Insets: Illegal character(s) before '['");
            }
            if (oneChar == ']') {
                if (!openBracketSeen) {
                    throw new IllegalArgumentException("Insets: Mismatched brackets: '[]'");
                }
                if (closeBracketSeen) {
                    throw new IllegalArgumentException("Insets: Only one ']' allowed");
                }
                changed = true;
                closeBracketSeen = true;
                continue;
            }
            if (closeBracketSeen) {
                throw new IllegalArgumentException("Insets: Illegal character(s) after ']'");
            }
            charSeen = true;
            chars[i++] = Character.toLowerCase(oneChar);
        }
        if (changed) {
            char[] newChars = new char[i];
            System.arraycopy(chars, 0, newChars, 0, i);
            chars = newChars;
        }
        return chars;
    }

    protected void parseOneValue(ParseContext context) {
        if (Character.isDigit(context.getChars()[context.getIndex()])) {
            this.parseUnnamedInsetValue(context, context.getChars());
        } else {
            this.parseNamedInsetValue(context);
        }
        this.skipToNextParameter(context, context.getChars());
    }

    private void skipToNextParameter(ParseContext context, char[] chars) {
        while (context.getIndex() < chars.length && chars[context.getIndex()] != ',') {
            context.incrementIndex();
        }
        context.incrementIndex();
        if (context.getIndex() >= chars.length) {
            context.setDone(true);
        }
    }

    private void parseNamedInsetValue(ParseContext context) {
        if (context.isUnnamedValueSeen()) {
            throw new IllegalArgumentException("Insets: Mixed named an unnamed values");
        }
        context.setNamedValueSeen(true);
        throw new UnsupportedOperationException("named inset values not supported");
    }

    private void parseUnnamedInsetValue(ParseContext context, char[] chars) {
        if (context.isNamedValueSeen()) {
            throw new IllegalArgumentException("Insets: Mixed named an unnamed values");
        }
        context.setUnnamedValueSeen(true);
        int valueStartIndex = context.getIndex();
        while (context.getIndex() < chars.length && Character.isDigit(chars[context.getIndex()])) {
            context.incrementIndex();
        }
        int valueEndIndex = context.getIndex() - 1;
        int intValue = Integer.parseInt(new String(chars, valueStartIndex, valueEndIndex - valueStartIndex + 1));
        if (!context.isTopSeen()) {
            context.setTopSeen(true);
            this.top = intValue;
        } else if (!context.isLeftSeen()) {
            context.setLeftSeen(true);
            this.left = intValue;
        } else if (!context.isBottomSeen()) {
            context.setBottomSeen(true);
            this.bottom = intValue;
        } else if (!context.isRightSeen()) {
            context.setRightSeen(true);
            this.right = intValue;
        }
    }
}

