/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.layout;

import com.schneide.base.layout.StringInsets;
import com.schneide.base.system.Base;
import com.schneide.base.text.TextBuffer;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.base.text.transformation.Embrace;
import com.schneide.base.util.MapUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;

public class StringGridBagConstraints
extends GridBagConstraints {
    private static final String RELATIVE_REPRESENTATION = "relative";
    private static final String SINGLE_QUOTE = "'";
    private static final String COMMA = ",";
    private static final long serialVersionUID = 6487533274317707536L;
    private static final Map<Integer, String> ANCHOR_MAP = StringGridBagConstraints.buildAnchorMap();
    private static final String DEFAULT_ANCHOR = "CENTER";
    private static final Map<Integer, String> FILL_MAP = StringGridBagConstraints.buildFillMap();
    private static final String DEFAULT_FILL = "NONE";
    private final Map<String, IParameterParser> parameterParserMap = this.buildParameterParserMap();
    private static final Map<String, Integer> ANCHOR_CONSTANT_MAP = MapUtil.reverseMap(ANCHOR_MAP);
    private static final Map<String, Integer> FILL_CONSTANT_MAP = MapUtil.reverseMap(FILL_MAP);

    public StringGridBagConstraints() {
        this.reset();
    }

    public StringGridBagConstraints(GridBagConstraints that) {
        this.copyFromOld(that);
    }

    public StringGridBagConstraints(StringGridBagConstraints that) {
        this.copyFromOld(that);
    }

    public StringGridBagConstraints(StringGridBagConstraints that, String layoutParams) {
        this.copyFromOld(that);
        this.setValues(layoutParams);
    }

    public StringGridBagConstraints(String layoutParams) {
        this();
        this.setValues(layoutParams);
    }

    public String toString() {
        return Embrace.withAngleBrackets(this.getClass().getName());
    }

    public String paramString() {
        TextBuffer result = new TextBuffer();
        result.add("gridx=");
        result.add(this.gridx);
        result.add(",gridy=");
        result.add(this.gridy);
        result.add(",gridwidth=");
        result.add(this.gridwidth);
        result.add(",gridheight=");
        result.add(this.gridheight);
        result.add(",weightx=");
        result.add(this.weightx);
        result.add(",weighty=");
        result.add(this.weighty);
        result.add(",anchor=");
        result.add(this.convertAnchorToString(this.anchor));
        result.add(",fill=");
        result.add(this.convertFillToString(this.fill));
        result.add(",ipadx=");
        result.add(this.ipadx);
        result.add(",ipady=");
        result.add(this.ipady);
        result.add(",insets=");
        result.add(this.insets);
        return result.toString();
    }

    public String toParsableString() {
        String insetsString;
        DirectChunkBuffer result = new DirectChunkBuffer(COMMA);
        StringGridBagConstraints defs = new StringGridBagConstraints();
        if (this.gridx != defs.gridx) {
            result.append("gridx=" + this.gridx);
        }
        if (this.gridy != defs.gridy) {
            result.append("gridy=" + this.gridy);
        }
        if (this.gridwidth != defs.gridwidth) {
            result.append("gridwidth=" + this.gridwidth);
        }
        if (this.gridheight != defs.gridheight) {
            result.append("gridheight=" + this.gridheight);
        }
        if (this.weightx != defs.weightx) {
            result.append("weightx=" + this.weightx);
        }
        if (this.weighty != defs.weighty) {
            result.append("weighty=" + this.weighty);
        }
        if (this.anchor != defs.anchor) {
            result.append("anchor=" + this.convertAnchorToString(this.anchor));
        }
        if (this.fill != defs.fill) {
            result.append("fill=" + this.convertFillToString(this.fill));
        }
        if (this.ipadx != defs.ipadx) {
            result.append("ipadx=" + this.ipadx);
        }
        if (this.ipady != defs.ipady) {
            result.append("ipady=" + this.ipady);
        }
        if ((insetsString = this.getInsetsDifferenceString(defs)) != null) {
            result.append(insetsString);
        }
        return ((Object)result).toString();
    }

    private String getInsetsDifferenceString(StringGridBagConstraints defs) {
        if (this.insets != null && defs.insets != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("insets=[");
            buffer.append(this.insets.top);
            buffer.append(COMMA);
            buffer.append(this.insets.left);
            buffer.append(COMMA);
            buffer.append(this.insets.bottom);
            buffer.append(COMMA);
            buffer.append(this.insets.right);
            buffer.append("]");
            return buffer.toString();
        }
        return null;
    }

    private static Map<Integer, String> buildAnchorMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(10, DEFAULT_ANCHOR);
        result.put(11, "NORTH");
        result.put(12, "NORTHEAST");
        result.put(13, "EAST");
        result.put(14, "SOUTHEAST");
        result.put(15, "SOUTH");
        result.put(16, "SOUTHWEST");
        result.put(17, "WEST");
        result.put(18, "NORTHWEST");
        return result;
    }

    protected String convertAnchorToString(int newAnchor) {
        Integer key = newAnchor;
        if (ANCHOR_MAP.containsKey(key)) {
            return ANCHOR_MAP.get(key);
        }
        return DEFAULT_ANCHOR;
    }

    private static Map<Integer, String> buildFillMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(0, DEFAULT_FILL);
        result.put(1, "BOTH");
        result.put(2, "HORIZONTAL");
        result.put(3, "VERTICAL");
        return result;
    }

    protected String convertFillToString(int newFill) {
        Integer key = newFill;
        if (FILL_MAP.containsKey(key)) {
            return FILL_MAP.get(key);
        }
        return DEFAULT_FILL;
    }

    private void copyFromOld(GridBagConstraints that) {
        this.anchor = that.anchor;
        this.fill = that.fill;
        this.gridwidth = that.gridwidth;
        this.gridheight = that.gridheight;
        this.gridx = that.gridx;
        this.gridy = that.gridy;
        this.ipadx = that.ipadx;
        this.ipady = that.ipady;
        this.weightx = that.weightx;
        this.weighty = that.weighty;
        this.insets = that.insets == null ? null : (Insets)that.insets.clone();
    }

    @Override
    public Object clone() {
        super.clone();
        StringGridBagConstraints copy = new StringGridBagConstraints(this);
        return copy;
    }

    public void reset() {
        this.anchor = 10;
        this.fill = 0;
        this.gridwidth = 1;
        this.gridheight = 1;
        this.gridx = -1;
        this.gridy = -1;
        this.ipadx = 0;
        this.ipady = 0;
        this.weightx = 0.001;
        this.weighty = 0.001;
        if (this.insets == null) {
            this.insets = new Insets(0, 0, 0, 0);
        } else {
            this.insets.top = 0;
            this.insets.left = 0;
            this.insets.bottom = 0;
            this.insets.right = 0;
        }
    }

    public void copyFrom(StringGridBagConstraints that) {
        this.anchor = that.anchor;
        this.fill = that.fill;
        this.gridwidth = that.gridwidth;
        this.gridheight = that.gridheight;
        this.gridx = that.gridx;
        this.gridy = that.gridy;
        this.ipadx = that.ipadx;
        this.ipady = that.ipady;
        this.weightx = that.weightx;
        this.weighty = that.weighty;
        if (that.insets == null) {
            this.insets = null;
        } else if (this.insets == null) {
            this.insets = (Insets)that.insets.clone();
        } else {
            this.insets.top = that.insets.top;
            this.insets.left = that.insets.left;
            this.insets.bottom = that.insets.bottom;
            this.insets.right = that.insets.right;
        }
    }

    public void setValues(String layoutParams) {
        if (layoutParams == null) {
            return;
        }
        char[] chars = this.normalizeString(layoutParams);
        int i = 0;
        while (i < chars.length) {
            i = this.parseOneParameter(chars, i);
        }
    }

    private char[] normalizeString(String string) {
        boolean changed = false;
        int i = 0;
        int j = 0;
        char[] chars = string.toCharArray();
        boolean lastWasWhite = false;
        boolean parsingNameOrValue = false;
        for (j = 0; j < chars.length; ++j) {
            char oneChar = chars[j];
            if (Character.isWhitespace(oneChar)) {
                changed = true;
                lastWasWhite = true;
                continue;
            }
            if (parsingNameOrValue && lastWasWhite && (this.isNameChar(oneChar) || this.isValueChar(oneChar))) {
                throw new IllegalArgumentException("StringGridBagConstraints: white space in name or value, after '" + string.substring(0, j - 1) + SINGLE_QUOTE);
            }
            parsingNameOrValue = this.isNameChar(oneChar) || this.isValueChar(oneChar);
            chars[i++] = Character.toLowerCase(oneChar);
            lastWasWhite = false;
        }
        if (changed) {
            char[] newChars = new char[i];
            System.arraycopy(chars, 0, newChars, 0, i);
            chars = newChars;
        }
        return chars;
    }

    private boolean isNameChar(char c) {
        return Character.isLetterOrDigit(c);
    }

    private boolean isValueChar(char c) {
        return Character.isLetterOrDigit(c) || c == '[' || c == ']';
    }

    protected int parseOneParameter(char[] chars, int i) {
        int currentIndex;
        int nameStartIndex = currentIndex = i;
        while (currentIndex < chars.length && this.isNameChar(chars[currentIndex])) {
            ++currentIndex;
        }
        int nameEndIndex = currentIndex - 1;
        if (nameStartIndex < 0 || nameEndIndex < 0 || nameStartIndex > nameEndIndex) {
            return chars.length;
        }
        String name = new String(chars, nameStartIndex, nameEndIndex - nameStartIndex + 1);
        if (currentIndex > chars.length || chars[currentIndex] != '=') {
            throw new IllegalArgumentException("Could not find '=' after '" + name + SINGLE_QUOTE);
        }
        int valueStartIndex = ++currentIndex;
        if ("insets".equals(name)) {
            currentIndex = this.findInsetsValueEnd(chars, currentIndex);
        } else {
            while (currentIndex < chars.length && this.isValueChar(chars[currentIndex])) {
                ++currentIndex;
            }
            --currentIndex;
        }
        int valueEndIndex = currentIndex;
        if (valueEndIndex >= chars.length || valueStartIndex > valueEndIndex) {
            throw new IllegalArgumentException("Could not find value for '" + name + SINGLE_QUOTE);
        }
        String value = new String(chars, valueStartIndex, valueEndIndex - valueStartIndex + 1);
        this.setOneParameter(name, value);
        while (currentIndex < chars.length && chars[currentIndex] != ',') {
            ++currentIndex;
        }
        if (currentIndex < chars.length && chars[currentIndex] == ',') {
            ++currentIndex;
        }
        return currentIndex;
    }

    private Map<String, IParameterParser> buildParameterParserMap() {
        HashMap<String, IParameterParser> result = new HashMap<String, IParameterParser>();
        result.put("gridx", (name, value) -> this.parseGridx(name, value));
        result.put("gridy", (name, value) -> this.parseGridy(name, value));
        result.put("gridwidth", (name, value) -> this.parseGridwidth(name, value));
        result.put("gridheight", (name, value) -> this.parseGridheight(name, value));
        result.put("weightx", (name, value) -> this.parseWeightx(name, value));
        result.put("weighty", (name, value) -> this.parseWeighty(name, value));
        result.put("anchor", (name, value) -> this.parseAnchor(name, value));
        result.put("fill", (name, value) -> this.parseFill(name, value));
        result.put("insets", (name, value) -> this.getInsetsValueFromString(name, value));
        result.put("ipadx", (name, value) -> this.parseIPadx(name, value));
        result.put("ipady", (name, value) -> this.parseIPady(name, value));
        return result;
    }

    protected void setOneParameter(String name, String value) {
        String mapKey = name.toLowerCase();
        if (!this.parameterParserMap.containsKey(mapKey)) {
            throw new IllegalArgumentException("Unknown parameter specified: " + Embrace.withSingleQuotes(name));
        }
        this.parameterParserMap.get(mapKey).parseParameter(name, value);
    }

    protected void parseGridx(String name, String value) {
        int newgridx = -1;
        newgridx = value.equals(RELATIVE_REPRESENTATION) ? -1 : this.getIntegerValueFromString(name, value);
        if (newgridx != this.gridx) {
            this.gridx = newgridx;
        }
    }

    protected void parseIPady(String name, String value) {
        int newipady = this.getIntegerValueFromString(name, value);
        if (newipady != this.ipady) {
            this.ipady = newipady;
        }
    }

    protected void parseIPadx(String name, String value) {
        int newipadx = this.getIntegerValueFromString(name, value);
        if (newipadx != this.ipadx) {
            this.ipadx = newipadx;
        }
    }

    protected void parseFill(String name, String value) {
        int newfill = this.getFillValueFromString(name, value);
        if (newfill != this.fill) {
            this.fill = newfill;
        }
    }

    protected void parseAnchor(String name, String value) {
        int newanchor = this.getAnchorValueFromString(name, value);
        if (newanchor != this.anchor) {
            this.anchor = newanchor;
        }
    }

    protected void parseWeighty(String name, String value) {
        double newweighty = this.getDoubleValueFromString(name, value);
        if (newweighty != this.weighty) {
            this.weighty = newweighty;
        }
    }

    protected void parseWeightx(String name, String value) {
        double newweightx = this.getDoubleValueFromString(name, value);
        if (newweightx != this.weightx) {
            this.weightx = newweightx;
        }
    }

    protected void parseGridheight(String name, String value) {
        int newgridheight = 0;
        newgridheight = "remainder".equals(value) ? 0 : (value.equals(RELATIVE_REPRESENTATION) ? -1 : this.getIntegerValueFromString(name, value));
        if (newgridheight != this.gridheight) {
            this.gridheight = newgridheight;
        }
    }

    protected void parseGridwidth(String name, String value) {
        int newgridwidth = 0;
        newgridwidth = "remainder".equals(value) ? 0 : (value.equals(RELATIVE_REPRESENTATION) ? -1 : this.getIntegerValueFromString(name, value));
        if (newgridwidth != this.gridwidth) {
            this.gridwidth = newgridwidth;
        }
    }

    protected void parseGridy(String name, String value) {
        int newgridy = -1;
        newgridy = value.equals(RELATIVE_REPRESENTATION) ? -1 : this.getIntegerValueFromString(name, value);
        if (newgridy != this.gridy) {
            this.gridy = newgridy;
        }
    }

    private int findInsetsValueEnd(char[] chars, int index) {
        int currentIndex = index;
        if (chars[currentIndex] != '[') {
            throw new IllegalArgumentException("StringGridBagConstraints: insets value must be in brackets '[]'");
        }
        ++currentIndex;
        while (currentIndex < chars.length && chars[currentIndex] != ']') {
            ++currentIndex;
        }
        return currentIndex;
    }

    private int getIntegerValueFromString(String name, String value) {
        int intValue = 0;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad integer format for '" + name + SINGLE_QUOTE);
        }
        return intValue;
    }

    private double getDoubleValueFromString(String name, String value) {
        double doubleValue = 0.0;
        try {
            doubleValue = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad double format for '" + name + SINGLE_QUOTE);
        }
        return doubleValue;
    }

    protected int getAnchorValueFromString(String name, String value) {
        return this.getMapValueFromString(ANCHOR_CONSTANT_MAP, name, value);
    }

    protected int getFillValueFromString(String name, String value) {
        return this.getMapValueFromString(FILL_CONSTANT_MAP, name, value);
    }

    private int getMapValueFromString(Map<String, Integer> map, String name, String value) {
        String mapKey = value.toUpperCase();
        if (map.containsKey(mapKey)) {
            return map.get(mapKey);
        }
        throw new IllegalArgumentException("Illegal value for " + Embrace.withSingleQuotes(name) + ": " + value);
    }

    private void getInsetsValueFromString(String name, String value) {
        if (name == null) {
            Base.getLogger(this).warn("Name for grid constraint is null");
        }
        if (this.insets == null) {
            this.insets = new StringInsets();
        } else if (!(this.insets instanceof StringInsets)) {
            this.insets = new StringInsets(this.insets);
        }
        ((StringInsets)this.insets).setValues(value);
    }

    private static interface IParameterParser {
        public void parseParameter(String var1, String var2);
    }
}

