/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.wrapper;

import com.schneide.base.datatypes.collections.iterable.UpcastingIterable;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.VirtualFileBase;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;

public class AccessLoggingVirtualFileDecorator
extends VirtualFileBase {
    private final VirtualFile file;

    public AccessLoggingVirtualFileDecorator(VirtualFile file) {
        this.file = file;
    }

    @Override
    public VirtualFile createFile(String name) throws IOException {
        this.logAccess();
        return new AccessLoggingVirtualFileDecorator(this.file.createFile(name));
    }

    @Override
    public boolean hasChild(String name) {
        this.logAccess();
        return this.file.hasChild(name);
    }

    @Override
    public VirtualFile createAsFile() throws IOException {
        this.logAccess();
        return new AccessLoggingVirtualFileDecorator(this.file.createAsFile());
    }

    @Override
    public VirtualFile createAsDirectory() throws IOException {
        this.logAccess();
        return new AccessLoggingVirtualFileDecorator(this.file.createAsDirectory());
    }

    @Override
    public String getName() {
        this.logAccess();
        return this.file.getName();
    }

    @Override
    public String getAbsoluteName() {
        this.logAccess();
        return this.file.getAbsoluteName();
    }

    @Override
    public VirtualFile getParent() {
        this.logAccess();
        return new AccessLoggingVirtualFileDecorator(this.file.getParent());
    }

    @Override
    public VirtualFile getChild(String name) {
        this.logAccess();
        return new AccessLoggingVirtualFileDecorator(this.file.getChild(name));
    }

    @Override
    public Iterable<VirtualFile> listDirectory() {
        this.logAccess();
        return new UpcastingIterable(this.wrap(this.file.listDirectory()));
    }

    protected Iterable<AccessLoggingVirtualFileDecorator> wrap(Iterable<? extends VirtualFile> original) {
        ArrayList<AccessLoggingVirtualFileDecorator> result = new ArrayList<AccessLoggingVirtualFileDecorator>();
        for (VirtualFile virtualFile : original) {
            result.add(new AccessLoggingVirtualFileDecorator(virtualFile));
        }
        return result;
    }

    @Override
    public Iterable<VirtualFile> listDirectory(VirtualFileFilter filter) {
        this.logAccess();
        return new UpcastingIterable(this.wrap(this.file.listDirectory(filter)));
    }

    @Override
    public boolean isDirectory() {
        this.logAccess();
        return this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        this.logAccess();
        return this.file.isFile();
    }

    @Override
    public boolean isLocal() {
        this.logAccess();
        return this.file.isLocal();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.logAccess();
        return this.file.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.logAccess();
        return this.file.getOutputStream();
    }

    @Override
    public OutputStream getAppendingOutputStream() throws IOException {
        this.logAccess();
        return this.file.getAppendingOutputStream();
    }

    @Override
    public File getLocalFile() throws IOException {
        this.logAccess();
        return this.file.getLocalFile();
    }

    @Override
    public String getCanonicalName() throws IOException {
        this.logAccess();
        return this.file.getCanonicalName();
    }

    @Override
    public void disposeLocalFile(File localFile) throws IOException {
        this.logAccess();
        this.file.disposeLocalFile(localFile);
    }

    @Override
    public boolean exists() {
        this.logAccess();
        return this.file.exists();
    }

    @Override
    public void copyContentTo(VirtualFile copy) throws IOException {
        this.logAccess();
        this.file.copyContentTo(copy);
    }

    @Override
    public long saveContent(InputStream is) throws IOException {
        this.logAccess();
        return this.file.saveContent(is);
    }

    @Override
    public void setLastModified(long millis) {
        this.logAccess();
        this.file.setLastModified(millis);
    }

    @Override
    public long getLastModified() {
        this.logAccess();
        return this.file.getLastModified();
    }

    @Override
    public long getSize() throws IOException {
        this.logAccess();
        return this.file.getSize();
    }

    @Override
    public void dispose() throws IOException {
        this.logAccess();
        this.file.dispose();
    }

    @Override
    public boolean isEmptyDirectory() {
        this.logAccess();
        return this.file.isEmptyDirectory();
    }

    @Override
    public boolean canRead() {
        this.logAccess();
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        this.logAccess();
        return this.file.canWrite();
    }

    @Override
    public void renameTo(String newName) throws IOException {
        this.logAccess();
        this.file.renameTo(newName);
    }

    @Override
    public void move(VirtualFile destination) throws IOException {
        this.logAccess();
        this.file.move(destination);
    }

    protected void logAccess() {
        Throwable t = new Throwable();
        String calledMethod = t.getStackTrace()[1].getMethodName();
        String caller = t.getStackTrace()[2].toString();
        this.getLogger().debug(this.file.getAbsoluteName() + ": " + calledMethod + " from " + caller);
    }

    @Override
    public URL getUrl() {
        return this.file.getUrl();
    }
}

