/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.visitor;

import com.schneide.base.io.virtual.VirtualFile;
import java.io.IOException;

public abstract class VirtualFileVisitor {
    public void visitAllUnder(VirtualFile directory) throws IOException {
        if (!directory.isDirectory()) {
            return;
        }
        for (VirtualFile virtualFile : directory.listDirectory()) {
            this.handle(virtualFile);
        }
    }

    protected void handle(VirtualFile fileObject) throws IOException {
        if (fileObject.isDirectory()) {
            this.performOnDirectory(fileObject);
            this.visitAllUnder(fileObject);
        }
        if (fileObject.isFile()) {
            this.performOnFile(fileObject);
        }
    }

    protected void performOnDirectory(VirtualFile directory) throws IOException {
        if (null == directory) {
            throw new IOException("No directory given, cannot perform action.");
        }
    }

    protected abstract void performOnFile(VirtualFile var1) throws IOException;
}

