/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.visitor;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.io.virtual.visitor.VirtualFileVisitor;
import java.io.IOException;

public abstract class FilteredVirtualFileVisitor
extends VirtualFileVisitor {
    private final VirtualFileFilter blacklist;

    public FilteredVirtualFileVisitor() {
        this(VirtualFileFilter.nothing);
    }

    public FilteredVirtualFileVisitor(VirtualFileFilter blacklist) {
        this.blacklist = blacklist;
    }

    protected boolean isBlacklisted(VirtualFile fileObject) {
        return this.blacklist.accept(fileObject);
    }

    @Override
    protected void handle(VirtualFile fileObject) throws IOException {
        if (this.isBlacklisted(fileObject)) {
            return;
        }
        super.handle(fileObject);
    }
}

