/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.util;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import java.io.IOException;

public class FileStructureDumper
extends LoggedObject {
    public void dumpStructureOf(VirtualFile rootDirectory) throws IOException {
        this.dumpStructure(rootDirectory, 0);
    }

    protected void dumpStructure(VirtualFile fileObject, int indentation) throws IOException {
        if (fileObject.isFile()) {
            this.logLine(indentation, fileObject.getName() + " (" + fileObject.getSize() + ")");
            return;
        }
        this.logLine(indentation, "<" + fileObject.getName() + ">");
        for (VirtualFile virtualFile : fileObject.listDirectory()) {
            this.dumpStructure(virtualFile, indentation + 4);
        }
    }

    protected void logLine(int indentation, Object message) {
        this.getLogger().debug(this.getIndentationString(indentation) + String.valueOf(message));
    }

    protected String getIndentationString(int indentation) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < indentation; ++i) {
            result.append(" ");
        }
        return result.toString();
    }
}

