/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.util;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import java.io.IOException;

public final class Copy {
    private Copy() {
    }

    public static RecursiveCopy all() {
        return new RecursiveCopy(ExistingFiles.OVERWRITE);
    }

    public static OnlyFilesCopy onlyFiles() {
        return new OnlyFilesCopy(ExistingFiles.OVERWRITE);
    }

    public static final class RecursiveCopy
    extends CopyBase<RecursiveCopy> {
        protected RecursiveCopy(ExistingFiles existing) {
            super(existing);
        }

        @Override
        protected String getCopyOperationDenotation() {
            return "recursively ";
        }

        @Override
        protected RecursiveCopy getIdentity() {
            return this;
        }

        @Override
        protected void copyDirectory(VirtualFile from, VirtualFile to) throws IOException {
            this.logCopyingOf(from, to);
            to.createAsDirectory();
            ((RecursiveCopy)new RecursiveCopy(this.existingFiles()).from(from)).to(to);
        }
    }

    protected static enum ExistingFiles {
        PRESERVE(true, "preserving"),
        OVERWRITE(false, "overwriting");

        private final String modeDenotation;
        private final boolean preserve;

        private ExistingFiles(boolean preserve, String modeDenotation) {
            this.preserve = preserve;
            this.modeDenotation = modeDenotation;
        }

        public String modeDenotation() {
            return this.modeDenotation;
        }

        public boolean mustBePreserved() {
            return this.preserve;
        }
    }

    public static final class OnlyFilesCopy
    extends CopyBase<OnlyFilesCopy> {
        protected OnlyFilesCopy(ExistingFiles existing) {
            super(existing);
        }

        @Override
        protected String getCopyOperationDenotation() {
            return "files only";
        }

        @Override
        protected OnlyFilesCopy getIdentity() {
            return this;
        }

        @Override
        protected void copyDirectory(VirtualFile from, VirtualFile to) throws IOException {
        }
    }

    protected static abstract class CopyBase<CB extends CopyBase<?>>
    extends LoggedObject {
        private VirtualFile sourceDirectory = null;
        private ExistingFiles existingFiles;

        protected CopyBase(ExistingFiles existingFiles) {
            this.existingFiles = existingFiles;
        }

        public CB from(VirtualFile newSourceDirectory) throws IOException {
            this.checkIfDirectory(newSourceDirectory, "from");
            this.sourceDirectory = newSourceDirectory;
            return this.getIdentity();
        }

        protected abstract CB getIdentity();

        protected abstract String getCopyOperationDenotation();

        public CB butExisting() {
            this.existingFiles = ExistingFiles.PRESERVE;
            return this.getIdentity();
        }

        protected void checkIfDirectory(VirtualFile directory, String directionDenotation) throws IOException {
            if (!directory.isDirectory()) {
                throw new IOException("Cannot copy " + this.getCopyOperationDenotation() + directionDenotation + " the given filesystem object, it isn't a directory: " + String.valueOf(directory));
            }
        }

        public void to(VirtualFile targetDirectory) throws IOException {
            if (null == this.sourceDirectory) {
                throw new IOException("Cannot copy to target directory without a source directory specified first.");
            }
            this.checkIfDirectory(targetDirectory, "to");
            this.performCopy(this.sourceDirectory, targetDirectory);
        }

        protected void performCopy(VirtualFile source, VirtualFile target) throws IOException {
            this.getLogger().info("Copying from " + String.valueOf(source) + " to " + String.valueOf(target) + " " + this.getCopyOperationDenotation() + ", " + this.existingFiles.modeDenotation() + " existing files.");
            for (VirtualFile currentSource : source.listDirectory()) {
                VirtualFile currentTarget = target.getChild(currentSource.getName());
                this.performCopyOf(currentSource, currentTarget);
            }
        }

        protected void performCopyOf(VirtualFile currentSource, VirtualFile currentTarget) throws IOException {
            if (currentSource.isFile()) {
                this.copyFile(currentSource, currentTarget);
                return;
            }
            this.copyDirectory(currentSource, currentTarget);
        }

        protected void logCopyingOf(VirtualFile source, VirtualFile target) {
            this.getLogger().debug("Copying " + String.valueOf(source) + " to " + String.valueOf(target));
        }

        protected void copyFile(VirtualFile from, VirtualFile to) throws IOException {
            if (to.exists() && this.existingFiles.mustBePreserved()) {
                return;
            }
            this.logCopyingOf(from, to);
            to.createAsFile();
            from.copyContentTo(to);
        }

        protected abstract void copyDirectory(VirtualFile var1, VirtualFile var2) throws IOException;

        protected ExistingFiles existingFiles() {
            return this.existingFiles;
        }
    }
}

