/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.string;

import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.datatypes.collections.iterable.UpcastingIterable;
import com.schneide.base.io.encoding.Encoding;
import com.schneide.base.io.reader.LineBuilder;
import com.schneide.base.io.stream.pump.StreamPumper;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.VirtualFileBase;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.programming.NotYetImplementedException;
import com.schneide.base.text.Whitespace;
import com.schneide.base.text.parsing.LinesOf;
import com.schneide.base.timing.Clock;
import com.schneide.base.util.EqualsBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class StringVirtualFile
extends VirtualFileBase
implements EqualsBuilder.EqualComparable {
    public static final StringVirtualFile BASE_DIR = new StringVirtualFile(""){

        @Override
        public StringVirtualFile getParent() {
            return null;
        }
    };
    private final String name;
    private StringVirtualFile parent;
    private final Set<StringVirtualFile> children;
    private boolean existsAsDirectory;
    private StringBuilder content;
    private boolean exists;
    private long lastModified;
    private long size;
    private boolean isWindowsRoot;
    private Charset encoding;

    public StringVirtualFile(String parent, String name) {
        this(new StringVirtualFile(parent), name);
    }

    public StringVirtualFile(StringVirtualFile parent, String name) {
        this(parent, name, false);
    }

    public StringVirtualFile(StringVirtualFile parent, String name, boolean exists) {
        this(name, exists);
        this.setParent(parent);
        parent.addChild(this);
    }

    public StringVirtualFile(String name) {
        this(name, false);
    }

    public StringVirtualFile(String name, boolean exists) {
        this(name, exists, 0L);
    }

    public StringVirtualFile(String name, boolean exists, long size) {
        this(name, exists, size, StringVirtualFile.determineContent(exists));
    }

    public StringVirtualFile(String name, boolean exists, long size, String initialContent) throws IllegalArgumentException {
        if (null != initialContent && !exists) {
            throw new IllegalArgumentException("File cannot have content and doesn't exist at the same time");
        }
        this.name = name;
        this.exists = exists;
        this.children = new LinkedHashSet<StringVirtualFile>();
        this.existsAsDirectory = false;
        this.isWindowsRoot = false;
        this.content = new StringBuilder();
        if (null != initialContent) {
            this.content.append(initialContent);
        }
        this.size = size;
        this.lastModified = 0L;
        this.encoding = Encoding.utf8();
    }

    public static StringVirtualFile createFileFromContent(String name, String initialContent) {
        return new StringVirtualFile(name, true, initialContent.length(), initialContent);
    }

    public Iterable<Object> getValuesToCompare() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.getName());
        result.add(this.getParent());
        return result;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.isEqual(this, obj);
    }

    public int hashCode() {
        return EqualsBuilder.hashCodeFor(this);
    }

    private static String determineContent(boolean exists) {
        if (exists) {
            return "";
        }
        return null;
    }

    @Override
    public StringVirtualFile createAsFile() throws IOException {
        if (this.existsAsDirectory) {
            throw new IOException("Already exists and is no file " + this.getName());
        }
        if (!this.getParent().exists()) {
            throw new IOException("Parent directory does not exist: " + this.getParent().getAbsoluteName());
        }
        if (!this.exists) {
            this.exists = true;
            this.content = new StringBuilder();
        }
        return this;
    }

    public String getContent() {
        return this.content.toString();
    }

    public void append(CharSequence additionalContent) {
        this.content.append(additionalContent);
        this.correctSize();
    }

    public void appendLine(CharSequence line) {
        this.append(String.valueOf(line) + "\n");
    }

    public void appendLines(CharSequence ... lines) {
        this.appendLines(Arrays.asList(lines));
    }

    public void appendLines(Iterable<CharSequence> lines) {
        for (CharSequence each : lines) {
            this.appendLine(each);
        }
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public void renameTo(String newName) {
        throw new NotYetImplementedException();
    }

    @Override
    public void move(VirtualFile newFile) throws IOException {
        if (newFile.exists()) {
            throw new IOException("Destination file already exists: " + newFile.getAbsoluteName());
        }
        this.copyContentTo(newFile);
        this.dispose();
    }

    @Override
    public void dispose() throws IOException {
        for (StringVirtualFile virtualFile : this.getChildren()) {
            virtualFile.dispose();
        }
        if (null != this.parent) {
            this.parent.children.remove(this);
        }
        this.exists = false;
        this.existsAsDirectory = false;
        this.isWindowsRoot = false;
        this.clear();
    }

    public String toString() {
        return this.getAbsoluteName();
    }

    @Override
    public boolean isEmptyDirectory() {
        return this.children.isEmpty();
    }

    @Override
    public void setLastModified(long millis) {
        this.lastModified = millis;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    protected void correctSize() {
        this.size = this.content.length();
    }

    @Override
    public void copyContentTo(VirtualFile copy) throws IOException {
        copy.saveContent(this.getInputStream());
    }

    protected void setContentAs(StringBuilder newContent) {
        this.content = newContent;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.exists = true;
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                StringVirtualFile.this.setContentAs(new StringBuilder(new String(this.toByteArray(), StringVirtualFile.this.currentEncoding())));
                StringVirtualFile.this.correctSize();
            }
        };
    }

    protected Charset currentEncoding() {
        return this.encoding;
    }

    @Override
    public OutputStream getAppendingOutputStream() throws IOException {
        this.exists = true;
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                StringVirtualFile.this.append(super.toString(StringVirtualFile.this.currentEncoding().name()));
            }
        };
    }

    @Override
    public long saveContent(InputStream is) throws IOException {
        this.exists = true;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamPumper.just().copyBytes(is, buffer);
        this.setContent(buffer.toString(this.encoding.name()));
        return this.getSize();
    }

    public void setContent(String content) {
        this.content = new StringBuilder(content);
        this.setLastModified(Clock.now());
        this.correctSize();
    }

    public void setContentFromLines(String ... lines) {
        LineBuilder buffer = new LineBuilder();
        for (String line : lines) {
            buffer.addLine(line);
        }
        this.setContent(buffer.toString());
    }

    public StringVirtualFile withContent(String newContent) {
        this.setContent(newContent);
        return this;
    }

    public void addChild(StringVirtualFile child) {
        this.children.remove(child);
        this.children.add(child);
    }

    public void setParent(StringVirtualFile parent) {
        this.parent = parent;
        this.isWindowsRoot = this.determineWindowsRoot();
    }

    @Override
    public boolean exists() {
        return this.isDirectory() || this.exists;
    }

    public StringVirtualFile createSubDirectory(String newName) throws IOException {
        StringVirtualFile result = this.createFile(newName);
        result.createAsDirectory();
        return result;
    }

    @Override
    public StringVirtualFile createFile(String newName) throws IOException {
        return this.createFile(newName, true);
    }

    private StringVirtualFile createFile(String newName, boolean isExisting) throws IOException {
        if (!this.existsAsDirectory) {
            throw new IOException("Directory " + this.getName() + " does not exist.");
        }
        StringVirtualFile newFile = new StringVirtualFile(newName, isExisting);
        newFile.setLastModified(Clock.now().getMillis());
        newFile.setParent(this);
        this.addChild(newFile);
        return newFile;
    }

    @Override
    public void disposeLocalFile(File localFile) throws IOException {
    }

    @Override
    public String getAbsoluteName() {
        if (null == this.getParent() || BASE_DIR.equals(this.getParent())) {
            return this.name;
        }
        return this.getParent().getAbsoluteName() + "/" + this.getName();
    }

    @Override
    public StringVirtualFile getChild(String childName) {
        for (VirtualFile child : this.listDirectory()) {
            if (!childName.equals(child.getName())) continue;
            return (StringVirtualFile)child;
        }
        return new StringVirtualFile(this, childName);
    }

    @Override
    public boolean hasChild(String childName) {
        for (VirtualFile child : this.listDirectory()) {
            if (!childName.equals(child.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException("This string based virtual file doesn't exist (yet): " + this.getAbsoluteName());
        }
        if (null == this.content) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.content.toString().getBytes(this.encoding));
    }

    @Override
    public File getLocalFile() throws IOException {
        throw new FileNotFoundException("This is a StringVirtualFile, it will never return a real file.");
    }

    @Override
    public String getName() {
        if (this.isWindowsRoot) {
            return "";
        }
        return this.name;
    }

    protected final boolean determineWindowsRoot() {
        if (!this.isDirectory()) {
            return false;
        }
        if (this.name.length() > 3) {
            return false;
        }
        if (null != this.getParent() && BASE_DIR != this.getParent()) {
            return false;
        }
        if (this.name.length() < 2) {
            return false;
        }
        return ':' == this.name.charAt(1);
    }

    @Override
    public StringVirtualFile getParent() {
        if (null == this.parent) {
            StringVirtualFile.BASE_DIR.existsAsDirectory = true;
            return BASE_DIR;
        }
        return this.parent;
    }

    @Override
    public boolean isDirectory() {
        return this.existsAsDirectory;
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory() && this.exists();
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    private StringVirtualFile[] getChildren() {
        return this.children.toArray(new StringVirtualFile[this.children.size()]);
    }

    @Override
    public Iterable<VirtualFile> listDirectory() {
        return this.listDirectory(new ExistsFileFilter());
    }

    @Override
    public Iterable<VirtualFile> listDirectory(VirtualFileFilter filter) {
        ArrayList<StringVirtualFile> filteredResult = new ArrayList<StringVirtualFile>();
        for (StringVirtualFile file : this.getChildren()) {
            if (!filter.accept(file)) continue;
            filteredResult.add(file);
        }
        return new UpcastingIterable(filteredResult);
    }

    public void clear() {
        this.children.clear();
    }

    @Override
    public StringVirtualFile createAsDirectory() {
        if (null != this.getParent()) {
            this.getParent().createAsDirectory();
        }
        this.existsAsDirectory = true;
        this.isWindowsRoot = this.determineWindowsRoot();
        return this;
    }

    @Override
    public String getCanonicalName() {
        return this.getAbsoluteName();
    }

    public String dumpContent() {
        return this.dumpContent(0);
    }

    protected String dumpContent(int insets) {
        StringVirtualFile[] children2;
        LineBuilder result = new LineBuilder();
        for (StringVirtualFile stringVirtualFile : children2 = this.getChildren()) {
            result.addLine(Whitespace.blanks(insets) + stringVirtualFile.getName());
            if (!stringVirtualFile.isDirectory()) continue;
            result.addLine(Whitespace.blanks(insets) + stringVirtualFile.dumpContent(insets + 4));
        }
        return result.toString();
    }

    public Iterable<String> asLines() {
        return () -> {
            try {
                return LinesOf.stream(this.getInputStream());
            }
            catch (IOException e) {
                this.getLogger().error("Error retrieving input stream from " + this.getClass().getSimpleName(), e);
                return new EmptyIterable().iterator();
            }
        };
    }

    @Override
    public URL getUrl() {
        throw new UnsupportedOperationException();
    }

    public void changeEncodingTo(Charset newEncoding) {
        this.encoding = newEncoding;
    }

    public static StringVirtualFile empty() {
        return StringVirtualFile.createFileFromContent("empty", "");
    }

    private static final class ExistsFileFilter
    implements VirtualFileFilter {
        @Override
        public boolean accept(VirtualFile f) {
            return f.exists();
        }
    }
}

