/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.readonly;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.VirtualFileBase;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.io.virtual.readonly.ReadOnlyVirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;

public class ReadOnlyVirtualFileExtender
extends VirtualFileBase {
    private static final String READ_ONLY = "Read only!";
    private final ReadOnlyVirtualFile file;

    public ReadOnlyVirtualFileExtender(ReadOnlyVirtualFile file) {
        this.file = file;
    }

    @Override
    public ReadOnlyVirtualFileExtender createAsFile() throws IOException {
        if (this.file.exists() && this.file.isFile()) {
            return this;
        }
        throw new IOException(READ_ONLY);
    }

    @Override
    public void move(VirtualFile newFile) throws IOException {
        throw new IOException(READ_ONLY);
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public void copyContentTo(VirtualFile copy) throws IOException {
        this.file.copyContentTo(copy);
    }

    @Override
    public void disposeLocalFile(File localFile) throws IOException {
        this.file.disposeLocalFile(localFile);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public String getAbsoluteName() {
        return this.file.getAbsoluteName();
    }

    @Override
    public VirtualFile getChild(String name) {
        return this.wrapReadOnlyVirtualFile(this.file.getChild(name));
    }

    @Override
    public boolean hasChild(String name) {
        return this.file.hasChild(name);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.file.getInputStream();
    }

    @Override
    public long getLastModified() {
        return this.file.getLastModified();
    }

    @Override
    public File getLocalFile() throws IOException {
        return this.file.getLocalFile();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public VirtualFile getParent() {
        return this.wrapReadOnlyVirtualFile(this.file.getParent());
    }

    @Override
    public long getSize() throws IOException {
        return this.file.getSize();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isEmptyDirectory() {
        return this.file.isEmptyDirectory();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isLocal() {
        return this.file.isLocal();
    }

    private VirtualFile wrapReadOnlyVirtualFile(ReadOnlyVirtualFile readonlyFile) {
        if (readonlyFile instanceof VirtualFile) {
            return (VirtualFile)readonlyFile;
        }
        return new ReadOnlyVirtualFileExtender(readonlyFile);
    }

    private Iterable<VirtualFile> wrapReadOnlyVirtualFiles(Iterable<? extends ReadOnlyVirtualFile> files) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (ReadOnlyVirtualFile readOnlyVirtualFile : files) {
            result.add(this.wrapReadOnlyVirtualFile(readOnlyVirtualFile));
        }
        return result;
    }

    @Override
    public Iterable<VirtualFile> listDirectory() {
        return this.wrapReadOnlyVirtualFiles(this.file.listDirectory());
    }

    @Override
    public Iterable<VirtualFile> listDirectory(VirtualFileFilter filter) {
        return this.wrapReadOnlyVirtualFiles(this.file.listDirectory(filter));
    }

    @Override
    public ReadOnlyVirtualFileExtender createAsDirectory() throws IOException {
        if (this.isDirectory()) {
            return this;
        }
        throw new IOException(READ_ONLY);
    }

    @Override
    public VirtualFile createFile(String name) throws IOException {
        throw new IOException(READ_ONLY);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException(READ_ONLY);
    }

    @Override
    public OutputStream getAppendingOutputStream() throws IOException {
        throw new IOException(READ_ONLY);
    }

    @Override
    public long saveContent(InputStream is) throws IOException {
        throw new IOException(READ_ONLY);
    }

    @Override
    public void renameTo(String newName) throws IOException {
        throw new IOException(READ_ONLY);
    }

    @Override
    public void dispose() throws IOException {
        throw new IOException(READ_ONLY);
    }

    @Override
    public void setLastModified(long millis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCanonicalName() throws IOException {
        return this.file.getCanonicalName();
    }

    @Override
    public URL getUrl() {
        return this.file.getUrl();
    }
}

