/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.readonly;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.io.virtual.util.FileExtension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;

public interface ReadOnlyVirtualFile {
    public String getName();

    default public String getExtension() {
        return FileExtension.of(this.getName());
    }

    default public boolean hasExtensionOf(String extension) {
        return extension.equalsIgnoreCase(this.getExtension());
    }

    default public boolean hasExtension() {
        return !"".equals(this.getExtension());
    }

    default public String nameWithoutExtension() {
        return FileExtension.removeFrom(this.getName());
    }

    public String getAbsoluteName();

    public ReadOnlyVirtualFile getParent();

    public ReadOnlyVirtualFile getChild(String var1);

    public boolean hasChild(String var1);

    public Iterable<? extends ReadOnlyVirtualFile> listDirectory();

    public Iterable<? extends ReadOnlyVirtualFile> listDirectory(VirtualFileFilter var1);

    public boolean isDirectory();

    public boolean isFile();

    public boolean isLocal();

    public InputStream getInputStream() throws IOException;

    public File getLocalFile() throws IOException;

    public void disposeLocalFile(File var1) throws IOException;

    public boolean exists();

    public void copyContentTo(VirtualFile var1) throws IOException;

    public long getLastModified();

    default public LocalDateTime lastModifiedIn(ZoneId timezone) {
        return Instant.ofEpochMilli(this.getLastModified()).atZone(timezone).toLocalDateTime();
    }

    default public LocalDateTime lastModified() {
        return this.lastModifiedIn(ZoneId.systemDefault());
    }

    public long getSize() throws IOException;

    public boolean isEmptyDirectory();

    default public boolean hasChildren() {
        return !this.isEmptyDirectory();
    }

    default public boolean isEmptyFile() throws IOException {
        return this.getSize() == 0L;
    }

    public boolean canRead();

    public boolean canWrite();

    public String getCanonicalName() throws IOException;

    public URL getUrl();

    default public Optional<Path> asPath() {
        try {
            return Optional.of(Path.of(this.getUrl().toURI()));
        }
        catch (RuntimeException | URISyntaxException e) {
            return Optional.empty();
        }
    }

    default public ReadOnlyVirtualFile withOtherExtension(String newExtension) {
        return this.getParent().getChild(FileExtension.changeFor(this.getName(), newExtension));
    }
}

