/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.readonly;

import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.io.virtual.readonly.ReadOnlyVirtualFile;
import com.schneide.base.io.virtual.readonly.ReadOnlyVirtualFileBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class NonExistingReadOnlyVirtualFile
extends ReadOnlyVirtualFileBase {
    private final ReadOnlyVirtualFile parent;
    private final String name;

    public NonExistingReadOnlyVirtualFile(ReadOnlyVirtualFile parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public boolean canRead() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public void copyContentTo(VirtualFile copy) throws IOException {
        throw new IOException("Cannot read from non-existent file: " + this.getAbsoluteName());
    }

    @Override
    public void disposeLocalFile(File localFile) throws IOException {
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public String getAbsoluteName() {
        return this.getParent().getName() + "/" + this.getName();
    }

    @Override
    public ReadOnlyVirtualFile getChild(String childName) {
        return new NonExistingReadOnlyVirtualFile(this, childName);
    }

    @Override
    public boolean hasChild(String childName) {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new IOException("Cannot obtain InputStream from non-existent file: " + this.getAbsoluteName());
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public File getLocalFile() throws IOException {
        throw new IOException("There is no local file of this non-existent file: " + this.getAbsoluteName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ReadOnlyVirtualFile getParent() {
        return this.parent;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isEmptyDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    public Iterable<ReadOnlyVirtualFile> listDirectory() {
        return new EmptyIterable<ReadOnlyVirtualFile>();
    }

    public Iterable<ReadOnlyVirtualFile> listDirectory(VirtualFileFilter filter) {
        return new EmptyIterable<ReadOnlyVirtualFile>();
    }

    @Override
    public String getCanonicalName() throws IOException {
        return this.getAbsoluteName();
    }

    @Override
    public URL getUrl() {
        throw new UnsupportedOperationException();
    }
}

