/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual.filter;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.timing.Clock;
import com.schneide.base.util.Parameter;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class AgeBasedFilter
extends LoggedObject
implements VirtualFileFilter {
    private final ReadablePeriod maximumAge;

    public AgeBasedFilter(ReadablePeriod maximumAge) {
        this.maximumAge = maximumAge;
    }

    @Override
    public boolean accept(VirtualFile f) {
        if (!this.acceptTypeOf(f) || !this.checkAdditionalConstraints(f)) {
            return false;
        }
        return this.isTooOld(new DateTime(f.getLastModified()));
    }

    protected boolean acceptTypeOf(VirtualFile filesystemObject) {
        Parameter.isPresent(filesystemObject);
        return true;
    }

    protected boolean checkAdditionalConstraints(VirtualFile file) {
        Parameter.isPresent(file);
        return true;
    }

    protected boolean isTooOld(DateTime date) {
        return this.getNow().isAfter((ReadableInstant)date.plus(this.maximumAge));
    }

    protected DateTime getNow() {
        return Clock.now();
    }
}

