/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.virtual;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.io.StreamProvider;
import com.schneide.base.io.encoding.Encoding;
import com.schneide.base.io.stream.BinaryContent;
import com.schneide.base.io.virtual.VirtualFileCollection;
import com.schneide.base.io.virtual.filter.VirtualFileFilter;
import com.schneide.base.io.virtual.readonly.ReadOnlyVirtualFile;
import com.schneide.base.io.virtual.util.FileExtension;
import com.schneide.base.io.writer.WriteTo;
import com.schneide.base.system.Base;
import com.schneide.base.text.parsing.StringChunker;
import com.schneide.base.text.transformation.Fillup;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.io.input.BOMInputStream;

public interface VirtualFile
extends ReadOnlyVirtualFile,
StreamProvider {
    public static final Charset defaultEncoding = Encoding.utf8();

    public VirtualFile createFile(String var1) throws IOException;

    public VirtualFile createAsFile() throws IOException;

    public VirtualFile createAsDirectory() throws IOException;

    @Override
    public String getName();

    @Override
    public String getAbsoluteName();

    @Override
    public VirtualFile getParent();

    @Override
    public VirtualFile getChild(String var1);

    public Iterable<VirtualFile> listDirectory();

    public Iterable<VirtualFile> listDirectory(VirtualFileFilter var1);

    @Override
    public boolean isDirectory();

    @Override
    public boolean isFile();

    @Override
    public boolean isLocal();

    @Override
    public InputStream getInputStream() throws IOException;

    default public Reader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.getInputStream())).get(), defaultEncoding));
    }

    default public Writer getWriter() throws IOException {
        return new BufferedWriter(new OutputStreamWriter(this.getOutputStream(), defaultEncoding));
    }

    default public void storeContentGivenBy(WriteTo.Writing content) throws IOException {
        try (PrintWriter print = new PrintWriter(this.getWriter());){
            content.writeTo(print);
        }
    }

    default public void storeContentGivenBy(BinaryContent content) throws IOException {
        try (OutputStream output = this.getOutputStream();
             BufferedOutputStream buffered = new BufferedOutputStream(output);){
            content.writeTo(buffered);
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException;

    public OutputStream getAppendingOutputStream() throws IOException;

    @Override
    public File getLocalFile() throws IOException;

    default public Path asLocalPath() throws IOException {
        return this.getLocalFile().toPath();
    }

    @Override
    public void disposeLocalFile(File var1) throws IOException;

    @Override
    public boolean exists();

    @Override
    public void copyContentTo(VirtualFile var1) throws IOException;

    public long saveContent(InputStream var1) throws IOException;

    public void setLastModified(long var1);

    @Override
    public long getLastModified();

    @Override
    public long getSize() throws IOException;

    public void dispose() throws IOException;

    @Override
    public boolean isEmptyDirectory();

    @Override
    public boolean canRead();

    @Override
    public boolean canWrite();

    public void renameTo(String var1) throws IOException;

    public void move(VirtualFile var1) throws IOException;

    default public void moveInto(VirtualFile targetDirectory) throws IOException {
        VirtualFile targetFile = targetDirectory.getChild(this.getName());
        this.move(targetFile);
    }

    default public void moveForcedInto(VirtualFile targetDirectory) throws IOException {
        VirtualFile targetFile = targetDirectory.getChild(this.getName());
        if (targetFile.isFile()) {
            targetFile.dispose();
        }
        this.move(targetFile);
    }

    default public VirtualFile moveWithoutPreservingNameTo(VirtualFile destinationDirectory) throws IOException {
        int attempts = 0;
        Optional<Object> result = Optional.empty();
        while (result.isEmpty()) {
            String suffix = attempts > 0 ? "_version" + Fillup.leadingWith("0", 3, String.valueOf(attempts)) : "";
            String extension = this.hasExtension() ? "." + this.getExtension() : "";
            String targetName = this.nameWithoutExtension() + suffix + extension;
            try {
                VirtualFile currentTarget = destinationDirectory.getChild(targetName);
                if (!currentTarget.exists()) {
                    if (attempts > 0) {
                        Base.getDefaultLogger().info("Saving " + this.getName() + " renamed to " + targetName + " into " + String.valueOf(destinationDirectory));
                    }
                    this.move(currentTarget);
                    result = Optional.of(currentTarget);
                }
            }
            catch (IOException e) {
                Base.getDefaultLogger().warn("Could not move " + this.getName() + " as " + targetName + " into " + String.valueOf(destinationDirectory) + " because of an I/O error.", e);
            }
            ++attempts;
        }
        return (VirtualFile)result.orElseThrow(() -> new IOException("Process error while moving the file " + this.getName() + " to " + String.valueOf(destinationDirectory)));
    }

    public VirtualFileCollection forEach(VirtualFileFilter var1);

    default public String allContent() throws IOException {
        return this.allContent(defaultEncoding);
    }

    default public String allContent(Charset encoding) throws IOException {
        StringBuilder result = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(this.getInputStream(), encoding);
             BufferedReader buffered = new BufferedReader(reader);){
            int c = 0;
            while (-1 != (c = buffered.read())) {
                result.append((char)c);
            }
        }
        return result.toString();
    }

    default public Optional<VirtualFile> maybeDirectory(String name) {
        VirtualFile child = this.getChild(name);
        if (child.isDirectory()) {
            return Optional.of(child);
        }
        return Optional.empty();
    }

    default public VirtualFile subdirectory(String name) throws IOException {
        Optional<VirtualFile> maybePresent = this.maybeDirectory(name);
        if (maybePresent.isPresent()) {
            return maybePresent.get();
        }
        return this.getChild(name).createAsDirectory();
    }

    default public void setContentTo(String text) throws IOException {
        this.setContentTo(text, defaultEncoding);
    }

    default public void setContentTo(String text, Charset encoding) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(this.getOutputStream(), encoding);
             PrintWriter printer = new PrintWriter(writer);){
            printer.print(text);
        }
    }

    default public String relativePathTo(VirtualFile parentDirectory) {
        String absolut = this.getAbsoluteName().replace('\\', '/');
        String referenz = parentDirectory.getAbsoluteName().replace('\\', '/');
        return absolut.replace(referenz + "/", "");
    }

    default public VirtualFile beneathBy(String path) {
        String normalizedPath = path.replace("\\", "/");
        StringChunker parts = new StringChunker(normalizedPath, "/");
        VirtualFile currentElement = this;
        while (parts.hasMoreChunks()) {
            String part = parts.getNextChunk();
            currentElement = currentElement.getChild(part);
        }
        return currentElement;
    }

    default public void mkdirs() throws IOException {
        if (this.exists()) {
            return;
        }
        this.getParent().mkdirs();
        this.createAsDirectory();
    }

    default public VirtualFile createParentDirectories() throws IOException {
        this.getParent().mkdirs();
        return this;
    }

    default public long lineCount(Charset encoding) throws IOException {
        long result = 0L;
        try (InputStream fromFile = this.getInputStream();
             InputStreamReader asCharacters = new InputStreamReader(fromFile, encoding);
             BufferedReader reader = new BufferedReader(asCharacters);){
            while (reader.readLine() != null) {
                ++result;
            }
        }
        return result;
    }

    default public Optional<VirtualFile> find(String nameWithWildcard) {
        int asterisk = nameWithWildcard.indexOf("*");
        if (asterisk == -1) {
            return Optional.of(this.beneathBy(nameWithWildcard)).filter(VirtualFile::exists);
        }
        String vergleichsbasis = nameWithWildcard.substring(0, asterisk);
        Iterable<VirtualFile> funde = this.listDirectory(vf -> vf.getName().startsWith(vergleichsbasis));
        return IterableUtil.maybeFirst(funde);
    }

    default public Optional<VirtualFile> maybeFile(String name) {
        VirtualFile child = this.getChild(name);
        if (child.isFile()) {
            return Optional.of(child);
        }
        return Optional.empty();
    }

    default public Iterable<VirtualFile> subdirectories() {
        return this.listDirectory(VirtualFileFilter.onlyDirectories);
    }

    default public Iterable<VirtualFile> containedFiles() {
        return this.listDirectory(VirtualFileFilter.onlyFiles);
    }

    default public Iterable<VirtualFile> listAllFilesEndingOn(String extension) {
        return this.listDirectory(vf -> vf.isFile() && vf.getName().toLowerCase().endsWith(extension.toLowerCase()));
    }

    default public Iterable<VirtualFile> listAllFilesMatching(String regularNameExpression) {
        Pattern pattern = Pattern.compile(regularNameExpression);
        return this.listDirectory(vf -> vf.isFile() && pattern.matcher(vf.getName()).matches());
    }

    @Override
    default public VirtualFile withOtherExtension(String newExtension) {
        return this.getParent().getChild(FileExtension.changeFor(this.getName(), newExtension));
    }
}

