/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.file;

import com.schneide.base.configuration.domain.ConfigurationLocationOf;
import com.schneide.base.io.file.Directory;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.logging.LoggedObject;
import java.io.IOException;
import java.util.Random;

public class TemporaryFileProvider
extends LoggedObject
implements Runnable {
    private final VirtualFile temporaryFileDirectory;
    private final Random random = new Random();
    private String defaultPrefix;
    private String defaultSuffix;

    public TemporaryFileProvider() {
        this(TemporaryFileProvider.getDefaultTemporaryFilesDirectory());
    }

    private static VirtualFile getDefaultTemporaryFilesDirectory() {
        try {
            return new LocalVirtualFile(Directory.ensureForPath(String.valueOf(ConfigurationLocationOf.stores()) + "/temporary"));
        }
        catch (IOException e) {
            TemporaryFileProvider.getStaticLogger().fatal("Could not retrieve temporary file directory.", e);
            return null;
        }
    }

    public TemporaryFileProvider(VirtualFile temporaryFileDirectory) {
        this(temporaryFileDirectory, false);
    }

    public TemporaryFileProvider(VirtualFile temporaryFileDirectory, boolean deleteOnShutdown) {
        this.ensureDirectory(temporaryFileDirectory);
        this.temporaryFileDirectory = temporaryFileDirectory;
        this.defaultPrefix = "tempfile";
        this.defaultSuffix = ".tmp";
        if (deleteOnShutdown) {
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)this, "cleanup of temporary directory " + this.temporaryFileDirectory.getName()));
        }
    }

    private void ensureDirectory(VirtualFile current) {
        if (current.isDirectory()) {
            return;
        }
        if (current.exists()) {
            this.getLogger().warn("Cannot use file " + String.valueOf(current) + " as temporary directory.");
        }
        try {
            current.createAsDirectory();
        }
        catch (IOException e) {
            this.getLogger().error("Could not create temporary directory " + String.valueOf(this.temporaryFileDirectory), e);
        }
    }

    public VirtualFile getTemporaryFile() throws IOException {
        return this.getTemporaryFile(this.getDefaultPrefix());
    }

    public VirtualFile getTemporaryFile(String prefix) throws IOException {
        return this.getTemporaryFile(prefix, this.getDefaultSuffix());
    }

    public VirtualFile getTemporaryFile(String prefix, String suffix) throws IOException {
        StringBuilder name = new StringBuilder();
        name.append(prefix);
        name.append(this.getCurrentEpochMilliseconds());
        name.append(this.getRandomNumber());
        name.append(suffix);
        VirtualFile result = this.temporaryFileDirectory.getChild(name.toString());
        if (result.exists()) {
            return this.getTemporaryFile(prefix, suffix);
        }
        return result;
    }

    protected long getCurrentEpochMilliseconds() {
        return System.currentTimeMillis();
    }

    protected long getRandomNumber() {
        return this.random.nextLong();
    }

    public VirtualFile createUniqueTemporaryFile() throws IOException {
        return this.createUniqueTemporaryFile(this.getDefaultPrefix());
    }

    public VirtualFile createUniqueTemporaryFile(String name) throws IOException {
        return this.createUniqueTemporaryFile(name, this.getDefaultSuffix());
    }

    public VirtualFile createUniqueTemporaryFile(String prefix, String suffix) throws IOException {
        return this.getTemporaryFile(prefix, suffix).createAsFile();
    }

    public VirtualFile createUniqueTemporaryDirectory(String name) throws IOException {
        return this.createUniqueTemporaryDirectory(name, this.getDefaultSuffix());
    }

    public VirtualFile createUniqueTemporaryDirectory(String prefix, String suffix) throws IOException {
        VirtualFile temp = this.createUniqueTemporaryFile(prefix, suffix);
        temp.dispose();
        return temp.createAsDirectory();
    }

    @Override
    public void run() {
        try {
            this.temporaryFileDirectory.dispose();
        }
        catch (IOException e) {
            this.getLogger().error("Could not delete temporary file directory " + String.valueOf(this.temporaryFileDirectory), e);
        }
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public void setDefaultPrefix(String defaultPrefix) {
        this.defaultPrefix = defaultPrefix;
    }

    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    public void setDefaultSuffix(String defaultSuffix) {
        this.defaultSuffix = defaultSuffix;
    }

    public void setDefaults(String newDefaultPrefix, String newDefaultSuffix) {
        this.setDefaultPrefix(newDefaultPrefix);
        this.setDefaultSuffix(newDefaultSuffix);
    }
}

