/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.file;

import com.schneide.base.datatypes.fixed.OperatingSystem;
import java.io.File;

public final class SystemDirectoriesProvider {
    private SystemDirectoriesProvider() {
    }

    public static File getUserHomeDirectory() {
        return SystemDirectoriesProvider.getDirectoryFor("user.home");
    }

    public static File getTemporaryDirectory() {
        return SystemDirectoriesProvider.getDirectoryFor("java.io.tmpdir");
    }

    public static File getCurrentWorkingDirectory() {
        return SystemDirectoriesProvider.getDirectoryFor("user.dir");
    }

    public static File getUserDesktopDirectoryFor(OperatingSystem platform) {
        if (OperatingSystem.WINDOWS == platform) {
            return new File(SystemDirectoriesProvider.getUserHomeDirectory(), "Desktop");
        }
        return SystemDirectoriesProvider.getUserHomeDirectory();
    }

    protected static File getDirectoryFor(String key) {
        return new File(SystemDirectoriesProvider.getSystemProperty(key));
    }

    protected static String getSystemProperty(String key) {
        return System.getProperty(key);
    }
}

