/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.file;

import com.schneide.base.datatypes.collections.ArrayUtil;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.model.I18Nable;
import com.schneide.base.io.stream.pump.StreamPumper;
import com.schneide.base.io.tools.IOCloser;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.system.Base;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.base.text.parsing.StringChunker;
import com.schneide.base.util.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FileUtil {
    public static final String DOT = ".";
    private static final int ASCII_CHAR_BOUNDARY = 128;
    private static final Character[] PROBLEMATIC_FILENAME_CHARACTERS = new Character[]{Character.valueOf(':'), Character.valueOf('$'), Character.valueOf(';'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('|'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('%'), Character.valueOf('='), Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('#'), Character.valueOf('&')};
    private static final char DEFAULT_REPLACEMENT_CHARACTER = '_';

    private FileUtil() {
    }

    public static File createFile(File directory, String filename) {
        return new File(directory, filename);
    }

    public static void copyFile(File source, File destination) throws IOException {
        FileUtil.copyFile(source, destination, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyFile(File source, File destination, boolean preserveModificationTimestamp) throws IOException {
        long result = -1L;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            result = StreamPumper.just().copyBytes((InputStream)in, out);
        }
        catch (Throwable throwable) {
            IOCloser.close(out);
            IOCloser.close(in);
            throw throwable;
        }
        IOCloser.close(out);
        IOCloser.close(in);
        if (preserveModificationTimestamp) {
            FileUtil.setModificationTimestamp(destination, source.lastModified());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long saveStreamAsFile(InputStream source, File destination) throws IOException {
        long result = -1L;
        FileOutputStream out = null;
        FileUtil.ensureDirectoryStructureForFile(destination);
        try {
            out = new FileOutputStream(destination);
            result = StreamPumper.just().copyBytes(source, out);
        }
        catch (Throwable throwable) {
            IOCloser.close(out);
            IOCloser.close(source);
            throw throwable;
        }
        IOCloser.close(out);
        IOCloser.close(source);
        return result;
    }

    public static void setModificationTimestamp(File file, long time) throws IOException {
        if (time < 0L) {
            FileUtil.ensureSuccess("Error while setting timestamp", file.setLastModified(System.currentTimeMillis()));
        } else {
            FileUtil.ensureSuccess("Error while setting timestamp", file.setLastModified(time));
        }
    }

    public static void ensureSuccess(String message, boolean success) throws IOException {
        if (!success) {
            throw new IOException(message);
        }
    }

    public static void ensureSuccessWithWarning(String message, boolean success) {
        if (!success) {
            Base.getLogger(FileUtil.class).warn(message);
        }
    }

    public static void delete(File file, I18Nable exceptionMessage) throws IOException {
        boolean success = file.delete();
        if (!success) {
            throw new IOException(exceptionMessage.resolvedText());
        }
    }

    public static void murderFile(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static void delete(File file) throws IOException {
        FileUtil.delete(file, new DirectText("Could not delete file " + file.getAbsolutePath()));
    }

    public static boolean deleteAll(File file) {
        return FileUtil.deleteAll(file, false);
    }

    public static boolean deleteAll(File file, boolean warnWhenFailure) {
        if (null == file || !file.exists()) {
            return false;
        }
        boolean success = true;
        File[] files = file.listFiles();
        if (null != files) {
            for (File element : files) {
                success &= FileUtil.deleteAll(element, warnWhenFailure);
            }
        }
        boolean mainFileSuccess = file.delete();
        if (warnWhenFailure && !mainFileSuccess) {
            Base.getLogger(FileUtil.class).warn("Could not delete file or directory: " + String.valueOf(file));
        }
        return success &= mainFileSuccess;
    }

    private static File getFirstDirectoryFor(File filesystemObject, boolean isFileIfNotExisting) {
        if (!filesystemObject.exists() && isFileIfNotExisting || filesystemObject.isFile()) {
            return filesystemObject.getParentFile();
        }
        return filesystemObject;
    }

    public static void ensureDirectoryStructureForFile(File file) throws IOException {
        FileUtil.ensureDirectoryTree(file, true);
    }

    public static void ensureDirectoryTree(File filesystemObject, boolean isFileIfNotExisting) throws IOException {
        Parameter.isPresent("filesystemObject", filesystemObject);
        File directory = FileUtil.getFirstDirectoryFor(filesystemObject, isFileIfNotExisting);
        if (null == directory || directory.exists()) {
            return;
        }
        if (!directory.mkdirs()) {
            throw new IOException("Could not create directory: " + directory.getAbsolutePath());
        }
    }

    public static String getWellFormattedFilenameFor(String proposal) {
        return FileUtil.getWellFormattedFilenameFor(proposal, '_');
    }

    public static String getWellFormattedFilenameFor(String proposal, char replacementCharacter) throws IllegalArgumentException {
        if (!FileUtil.isWellFormattedChar(replacementCharacter)) {
            throw new IllegalArgumentException("The replacement character isn't valid: " + replacementCharacter);
        }
        char[] chars = proposal.toCharArray();
        StringBuilder result = new StringBuilder();
        for (char c : chars) {
            if (FileUtil.isWellFormattedChar(c)) {
                result.append(c);
                continue;
            }
            result.append(replacementCharacter);
        }
        return result.toString();
    }

    private static boolean isWellFormattedChar(char c) {
        return FileUtil.isASCII(c) && !FileUtil.isProblematic(c);
    }

    private static boolean isASCII(char c) {
        return c < '\u0080';
    }

    private static boolean isProblematic(char c) {
        return ArrayUtil.contains(PROBLEMATIC_FILENAME_CHARACTERS, Character.valueOf(c));
    }

    public static String getRelativePath(File baseDir, File file) {
        Object relativePath = "";
        try {
            if (baseDir.getCanonicalPath().equals(file.getCanonicalPath())) {
                return relativePath;
            }
            for (File matchedDir = baseDir; null != matchedDir; matchedDir = matchedDir.getParentFile()) {
                if (FileUtil.directoryContainsFile(matchedDir, file)) {
                    String dirPath = file.getCanonicalPath().substring(matchedDir.getCanonicalPath().length());
                    dirPath = FileUtil.stripLeadingOrTrailingSeparators(dirPath);
                    return FileUtil.stripLeadingOrTrailingSeparators((String)relativePath + File.separator + dirPath);
                }
                if (((String)relativePath).isEmpty()) {
                    relativePath = "..";
                    continue;
                }
                relativePath = ".." + File.separator + (String)relativePath;
            }
        }
        catch (IOException e) {
            Base.getLogger(FileUtil.class).error("Could not retrieve relative path of " + String.valueOf(file), e);
        }
        return file.getAbsolutePath();
    }

    private static String stripLeadingOrTrailingSeparators(String dirPath) {
        String path = dirPath;
        while (path.startsWith(File.separator)) {
            path = path.substring(File.separator.length());
        }
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - File.separator.length());
        }
        return path;
    }

    public static synchronized String getNewNonConflictingFilename(File dir, String startingFilename) {
        String filename;
        if (!new File(dir, startingFilename).exists()) {
            return startingFilename;
        }
        String startingFilenameWithoutExtension = startingFilename;
        String extension = "";
        if (new File(dir, startingFilename).isFile()) {
            startingFilenameWithoutExtension = FileUtil.getWithoutExtension(startingFilename);
            if (FileUtil.hasExtension(startingFilename)) {
                extension = FileUtil.getExtensionOf(startingFilename);
            }
        }
        int counter = 1;
        do {
            filename = startingFilenameWithoutExtension + "-" + counter + extension;
            ++counter;
        } while (new File(dir, filename).exists());
        return filename;
    }

    public static synchronized String getNewNonConflictingFilename(VirtualFile dir, String startingFilename) {
        String filename;
        if (!dir.getChild(startingFilename).exists()) {
            return startingFilename;
        }
        String startingFilenameWithoutExtension = startingFilename;
        String extension = "";
        if (dir.getChild(startingFilename).isFile()) {
            startingFilenameWithoutExtension = FileUtil.getWithoutExtension(startingFilename);
            if (FileUtil.hasExtension(startingFilename)) {
                extension = FileUtil.getExtensionOf(startingFilename);
            }
        }
        int counter = 1;
        do {
            filename = startingFilenameWithoutExtension + "-" + counter + extension;
            ++counter;
        } while (dir.getChild(filename).exists());
        return filename;
    }

    private static boolean hasExtension(String startingFilename) {
        return startingFilename.contains(DOT);
    }

    public static String getExtensionOf(String startingFilename) {
        StringChunker chunker = new StringChunker(startingFilename, DOT);
        return DOT + chunker.getLastChunk();
    }

    public static String getWithoutExtension(String startingFilename) {
        StringChunker chunker = new StringChunker(startingFilename, DOT);
        String[] chunks = chunker.getAllChunksAsArray();
        if (1 == chunks.length) {
            return startingFilename;
        }
        DirectChunkBuffer buffer = new DirectChunkBuffer(DOT);
        for (int i = 0; i < chunks.length - 1; ++i) {
            buffer.add(chunks[i]);
        }
        return ((Object)buffer).toString();
    }

    public static String getWithoutExtensions(String startingFilename) {
        String result = startingFilename;
        while (result.contains(DOT)) {
            result = FileUtil.getWithoutExtension(result);
        }
        return result;
    }

    public static boolean directoryContainsFile(File dir, File file) throws IOException {
        return file.getCanonicalPath().startsWith(dir.getCanonicalPath());
    }

    public static boolean isExistingDirectory(File directory) {
        return null != directory && directory.exists() && directory.isDirectory();
    }

    public static boolean isExistingFile(File file) {
        return null != file && file.isFile();
    }

    public static boolean isReadableFile(File file) {
        return FileUtil.isExistingFile(file) && file.canRead();
    }

    public static boolean isFullyAccessibleFile(File file) {
        return FileUtil.isReadableFile(file) && file.canWrite();
    }

    public static String insertSuffixBeforeExtension(String filename, String suffix) {
        return FileUtil.getWithoutExtension(filename) + suffix + FileUtil.getExtensionOf(filename);
    }
}

