/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.file;

import com.schneide.base.text.Text;

public class FilePath {
    private static final String SLASH = "/";
    private static final String BACKSLASH = "\\";
    private final String path;

    public FilePath(String path) {
        this.path = path;
    }

    public FilePath with(String append) {
        return this.with(new FilePath(append));
    }

    public FilePath with(FilePath append) {
        String toAppend = Text.modify(append.normalized()).ifMissing().prepend(SLASH);
        if (this.endsWithSlash()) {
            toAppend = Text.modify(append.normalized()).removeLeading(SLASH);
        }
        return new FilePath(this.path + toAppend);
    }

    public boolean endsWithSlash() {
        return this.normalized().endsWith(SLASH);
    }

    public String asText() {
        return this.normalized();
    }

    public String forWindowsPlatform() {
        return FilePath.asWindowsPlatformString(this.path);
    }

    public String forUnixPlatform() {
        return FilePath.asUnixPlatformString(this.path);
    }

    public String normalized() {
        return FilePath.asNormalizedPath(this.path);
    }

    public static String asWindowsPlatformString(String filepath) {
        return filepath.replace(SLASH, BACKSLASH);
    }

    public static String asUnixPlatformString(String filepath) {
        return filepath.replace(BACKSLASH, SLASH);
    }

    public static String asNormalizedPath(String filepath) {
        return FilePath.asUnixPlatformString(filepath);
    }

    public String toString() {
        return this.asText();
    }
}

