/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.file;

import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.datatypes.collections.iterable.CollectionIterable;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public final class FileLister {
    public static final FileFilter FILES_ONLY_FILTER = pathname -> pathname.isFile();
    public static final FileFilter DIRS_ONLY_FILTER = pathname -> pathname.isDirectory();

    private FileLister() {
    }

    public static File[] listFiles(File directory) {
        return FileLister.ensureFileArrayInstance(directory.listFiles());
    }

    public static File[] listFiles(File directory, FileFilter filter) {
        return FileLister.ensureFileArrayInstance(directory.listFiles(filter));
    }

    public static File[] listFiles(File directory, FileFilter filter, boolean isRecursiveEnabled) {
        if (isRecursiveEnabled) {
            return FileLister.listFilesRecursively(directory, filter);
        }
        return FileLister.listFiles(directory, filter);
    }

    public static File[] listFilesRecursively(File directory, FileFilter filter) {
        ArrayList<File> directoriesList = new ArrayList<File>();
        ArrayList resultList = new ArrayList();
        directoriesList.add(directory);
        while (!directoriesList.isEmpty()) {
            DirectoryContent content = FileLister.workOnDirectory((File)directoriesList.remove(0), filter);
            CollectionUtil.addAll(directoriesList, content.getDirectories());
            CollectionUtil.addAll(resultList, content.getFiles());
        }
        return resultList.toArray(new File[resultList.size()]);
    }

    protected static DirectoryContent workOnDirectory(File directory, FileFilter filter) {
        File[] files;
        DirectoryContent result = new DirectoryContent();
        for (File file : files = FileLister.listFiles(directory)) {
            if (file.isDirectory()) {
                result.addDirectory(file);
            }
            if (!filter.accept(file)) continue;
            result.addFile(file);
        }
        return result;
    }

    public static File[] listFilesWithEnding(File directory, String ... nameEndings) {
        return FileLister.listFiles(directory, FileLister.getFilterForFilesWithEnding(nameEndings));
    }

    public static FileFilter getFilterForFilesWithEnding(final String ... nameEndings) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.exists() && pathname.isFile() && this.isNameMatching(pathname.getName());
            }

            private boolean isNameMatching(String filename) {
                for (String name : nameEndings) {
                    if (!filename.endsWith(name)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static File[] ensureFileArrayInstance(File[] current) {
        File[] result = current;
        if (null == result) {
            result = new File[]{};
        }
        return result;
    }

    private static class DirectoryContent {
        private final List<File> files = new ArrayList<File>();
        private final List<File> directories = new ArrayList<File>();

        public void addFile(File file) {
            this.files.add(file);
        }

        public void addDirectory(File directory) {
            this.directories.add(directory);
        }

        public Iterable<File> getDirectories() {
            return new CollectionIterable<File>(this.directories);
        }

        public Iterable<File> getFiles() {
            return new CollectionIterable<File>(this.files);
        }
    }
}

