/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.file;

import com.schneide.base.logging.LoggedObject;
import java.io.File;
import java.io.IOException;

public final class Directory
extends LoggedObject {
    private Directory() {
    }

    public static File forPath(File base, String relativePath) {
        return new File(base, relativePath);
    }

    public static File forPath(String path) {
        return new File(path);
    }

    public static File ensureForPath(String path) throws IOException {
        boolean success;
        File result = Directory.forPath(path);
        if (!result.exists() && !(success = result.mkdirs())) {
            throw new IOException("Could not create directory structure for " + path);
        }
        return result;
    }

    public static File ensureForPathOrFailFast(String path) {
        try {
            return Directory.ensureForPath(path);
        }
        catch (IOException e) {
            Directory.getStaticLogger().fatal("Could not ensure directory for " + path, e);
            return null;
        }
    }
}

