/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.file;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.text.parsing.StringChunker;
import java.io.File;
import java.io.IOException;

public final class CreateDirectories {
    private final VirtualFile root;

    private CreateDirectories(VirtualFile root) {
        this.root = root;
    }

    public static CreateDirectories beneath(File directory) {
        return CreateDirectories.beneath(new LocalVirtualFile(directory));
    }

    public static CreateDirectories beneath(VirtualFile directory) {
        return new CreateDirectories(directory);
    }

    public void forPath(String path) throws IOException {
        StringChunker chunker = new StringChunker(path, "/");
        VirtualFile currentDirectory = this.root;
        while (chunker.hasNext()) {
            String directoryName = chunker.next();
            currentDirectory = currentDirectory.getChild(directoryName).createAsDirectory();
        }
    }
}

