/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.io.compression;

import com.schneide.base.io.compression.ZipperEntry;
import com.schneide.base.io.stream.provider.OutputStreamProvider;
import com.schneide.base.io.stream.pump.StreamPumper;
import com.schneide.base.logging.LoggedObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileZipper
extends LoggedObject {
    private final List<ZipperEntry> entryList = new ArrayList<ZipperEntry>();
    private final OutputStreamProvider target;
    private String comment;

    public FileZipper(File targetFile, String comment) {
        this(new FileBasedOutputStreamProvider(targetFile), comment);
    }

    public FileZipper(OutputStreamProvider target, String comment) {
        this.target = target;
        this.setComment(comment);
    }

    public synchronized void addFile(File file) throws IOException {
        this.addFileUnder(file, "");
    }

    public synchronized void addFileUnder(File file, String newPath) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] subFiles;
                for (File element : subFiles = file.listFiles()) {
                    this.addFileUnder(element, newPath + File.separator + file.getName());
                }
            } else {
                this.entryList.add(new ZipperEntry(file, newPath));
            }
        }
    }

    public synchronized void addZipperEntry(ZipperEntry entry) {
        this.entryList.add(entry);
    }

    public synchronized void writeZip(CompressionLevel compressionLevel) throws IOException {
        try (ZipOutputStream zipStream = new ZipOutputStream(this.target.stream());){
            zipStream.setComment(this.getComment());
            zipStream.setLevel(compressionLevel.getCompressionLevelAsInt());
            for (ZipperEntry zipperEntry : this.entryList) {
                this.writeEntry(zipStream, zipperEntry);
            }
            zipStream.finish();
        }
    }

    private void writeEntry(ZipOutputStream zipStream, ZipperEntry toZip) throws IOException {
        try (InputStream zipSource = toZip.getInputStream();){
            ZipEntry zipEntry = new ZipEntry(toZip.getZipPath());
            zipStream.putNextEntry(zipEntry);
            StreamPumper.just().pumpBytes(toZip.getLength(), zipSource, zipStream);
            zipStream.closeEntry();
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public static class FileBasedOutputStreamProvider
    implements OutputStreamProvider {
        private final File targetFile;

        public FileBasedOutputStreamProvider(File targetFile) {
            this.targetFile = targetFile;
        }

        @Override
        public OutputStream stream() throws IOException {
            return new FileOutputStream(this.targetFile);
        }
    }

    public static enum CompressionLevel {
        HIGHEST(9),
        HIGHER(8),
        HIGH(7),
        ABOVE_AVERAGE(6),
        MEDIUM(5),
        BELOW_AVERAGE(4),
        LOW(3),
        LOWER(2),
        LOWEST(1),
        NONE(0);

        private int internalCompressionLevel;

        private CompressionLevel(int internalCompressionLevel) {
            this.internalCompressionLevel = internalCompressionLevel;
        }

        public int getCompressionLevelAsInt() {
            return this.internalCompressionLevel;
        }
    }
}

