/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.validation;

import com.schneide.base.i18n.EmptyText;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.validation.ValidationMessageType;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.system.Base;

public abstract class AbstractValidationResult
implements ValidationResult {
    private final String message;
    private final Input source;

    protected AbstractValidationResult() {
        this(new EmptyText());
    }

    protected AbstractValidationResult(I18NResolvable message) {
        this(null, message);
    }

    protected AbstractValidationResult(Input source, I18NResolvable message) {
        this.source = source;
        this.message = AbstractValidationResult.createValidationMessageFrom(source, message.resolvedText());
    }

    private static String createValidationMessageFrom(Input source, String resolvedBaseMessage) {
        if (null == source) {
            return resolvedBaseMessage;
        }
        return Base.getTextContent().getParametrizedText("AbstractValidationResult.input.source.message.title", source.getTitle(), resolvedBaseMessage);
    }

    @Override
    public abstract boolean isCorrect();

    @Override
    public abstract ValidationMessageType getMessageType();

    @Override
    public abstract boolean needsDisplay();

    @Override
    public abstract String getCategoryMessage();

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Input getSource() {
        return this.source;
    }
}

