/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.types;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.TextfieldInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.generic.ValueBase;
import com.schneide.base.input.types.i18n.EmptyValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.input.types.validation.StringValidationAspect;
import com.schneide.base.input.validation.IgnoredInputResult;
import com.schneide.base.input.validation.ValidInputResult;
import com.schneide.base.input.validation.ValidationResult;
import java.util.ArrayList;
import java.util.List;

public class StringValue
extends ValueBase {
    private final List<StringValidationAspect> validationAspects = new ArrayList<StringValidationAspect>();
    private boolean isNullAware = false;

    public StringValue() {
        this(new EmptyValueInformation());
    }

    public StringValue(ValueInformation valueInfo) {
        this(valueInfo, "");
    }

    public StringValue(ValueInformation valueInfo, String originalValue) {
        super(valueInfo, originalValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStringValidationAspect(StringValidationAspect aspect) {
        if (null != aspect) {
            List<StringValidationAspect> list = this.validationAspects;
            synchronized (list) {
                this.validationAspects.add(aspect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStringValidationAspect(StringValidationAspect aspect) {
        if (null != aspect) {
            List<StringValidationAspect> list = this.validationAspects;
            synchronized (list) {
                this.validationAspects.remove(aspect);
            }
        }
    }

    @Override
    protected Iterable<ValidationResult> internalValidation() {
        if (this.getSource() == null) {
            return new SingleElementIterable<ValidationResult>(new IgnoredInputResult(this.getSource()));
        }
        return this.validateByAspects();
    }

    private Iterable<ValidationResult> validateByAspects() {
        ArrayList<ValidationResult> resultList = new ArrayList<ValidationResult>();
        resultList.add(new ValidInputResult(this.getSource()));
        for (StringValidationAspect aspect : this.validationAspects) {
            resultList.add(aspect.validate(this.getValue(), this.getSource()));
        }
        return resultList;
    }

    public String getValue() {
        if (this.hasSource()) {
            return this.ensureNullAwareness(this.getSource().getText());
        }
        if (null == this.getOriginalValue()) {
            if (this.isNullAware()) {
                return "";
            }
            return null;
        }
        return String.valueOf(this.getOriginalValue());
    }

    @Override
    public String getRestrictionDescription() {
        return Localisation.getLocalizedString("value.string.input.description");
    }

    @Override
    public String getUnitString() {
        return "";
    }

    public void setValue(String value) {
        this.setOriginalValueIfNoSource(this.ensureNullAwareness(value));
        this.setInputText(this.ensureNullAwareness(value));
    }

    private String ensureNullAwareness(String value) {
        if (null == value && this.isNullAware()) {
            return "";
        }
        return value;
    }

    public boolean isNullAware() {
        return this.isNullAware;
    }

    public void setNullAware(boolean newAwarenessState) {
        this.isNullAware = newAwarenessState;
    }

    @Override
    protected String getCurrentValueRepresentation() {
        return this.getTextualValue();
    }

    @Override
    public String getTextualValue() {
        return this.getValue();
    }

    @Override
    @Deprecated
    public Input createNaturalInput() {
        return new TextfieldInput(this, 15);
    }

    @Override
    public Input createNaturalInput(InputFactory factory) {
        return factory.getTextfieldInputFor(this);
    }
}

