/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.types;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.input.datatypes.ValueBound;
import com.schneide.base.input.global.GlobalInputFrameworkOptions;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.TextfieldInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.generic.ValueBase;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.input.validation.InvalidInputResult;
import com.schneide.base.input.validation.ValidInputResult;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.util.Parameter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;

public class QuantityValue<Q extends Quantity>
extends ValueBase {
    private final Unit<Q> unit;
    private Amount<Q> value;
    private DecimalFormat formatter;
    private final List<ValueBound> bounds;

    public QuantityValue(ValueInformation information, Unit<Q> unit, Amount<Q> initialValue) throws IllegalArgumentException {
        super(information, initialValue);
        if (null == unit) {
            throw new IllegalArgumentException("Sorry, QuantityValue needs an unit to perform sane (it was null).");
        }
        this.unit = unit;
        this.value = initialValue;
        this.formatter = new DecimalFormat("0.#############", new DecimalFormatSymbols(Locale.ENGLISH));
        this.bounds = new ArrayList<ValueBound>();
    }

    public QuantityValue(ValueInformation information, Unit<Q> unit, Double initialValue) throws IllegalArgumentException {
        this(information, unit, QuantityValue.getAmountFor(initialValue, unit));
    }

    private static <Q extends Quantity> Amount<Q> getAmountFor(Double initialValue, Unit<Q> unit) {
        if (null == initialValue) {
            return null;
        }
        return Amount.valueOf((double)initialValue, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValueBounds(ValueBound ... valueBounds) {
        List<ValueBound> list = this.bounds;
        synchronized (list) {
            Collections.addAll(this.bounds, valueBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValueBounds(ValueBound ... valueBounds) {
        List<ValueBound> list = this.bounds;
        synchronized (list) {
            for (ValueBound valueBound : valueBounds) {
                this.bounds.remove(valueBound);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueBound[] getValueBounds() {
        List<ValueBound> list = this.bounds;
        synchronized (list) {
            return this.bounds.toArray(new ValueBound[this.bounds.size()]);
        }
    }

    @Override
    @Deprecated
    public Input createNaturalInput() {
        return new TextfieldInput(this);
    }

    @Override
    public Input createNaturalInput(InputFactory factory) {
        return factory.getTextfieldInputFor(this);
    }

    @Override
    protected String getCurrentValueRepresentation() {
        return this.getFormattedValue();
    }

    @Override
    public String getRestrictionDescription() {
        ValueBound[] valueBounds;
        StringBuilder result = new StringBuilder();
        result.append(Localisation.getLocalizedString("value.quantity.input.description"));
        for (ValueBound valueBound : valueBounds = this.getValueBounds()) {
            result.append(valueBound.getDescription());
        }
        return result.toString();
    }

    protected String getFormattedValue() {
        return this.getFormattedValueFor(this.getValue());
    }

    protected String getFormattedValueFor(Amount<Q> toFormat) {
        if (null == toFormat) {
            return "";
        }
        return this.getFormatter().format(toFormat.doubleValue(this.getUnit()));
    }

    protected DecimalFormat getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DecimalFormat formatter) {
        this.formatter = formatter;
    }

    protected Unit<Q> getUnit() {
        return this.unit;
    }

    @Override
    public String getTextualValue() {
        return this.getFormattedValue();
    }

    @Override
    public String getUnitString() {
        return this.getUnit().toString();
    }

    @Override
    protected Iterable<ValidationResult> internalValidation() {
        try {
            if (!this.isInputTextParseable()) {
                return new SingleElementIterable<ValidationResult>(new InvalidInputResult(this.getSource(), Localisation.getLocalizedText("value.double.error.invalidInput")));
            }
            Double currentValue = this.getNumericValue();
            ValueBound exceededValueBound = this.getExceededValueBound(currentValue);
            if (null != exceededValueBound) {
                return new SingleElementIterable<ValidationResult>(new InvalidInputResult(this.getSource(), new DirectText(Localisation.getLocalizedString("value.error.rangeExceeded") + exceededValueBound.getDescription())));
            }
            return new SingleElementIterable<ValidationResult>(new ValidInputResult(this.getSource()));
        }
        catch (NumberFormatException e) {
            Parameter.isPresent(e);
            return new SingleElementIterable<ValidationResult>(new InvalidInputResult(this.getSource(), Localisation.getLocalizedText("value.double.error.invalidInput")));
        }
    }

    private ValueBound getExceededValueBound(Double testedValue) {
        ValueBound[] currentBounds;
        for (ValueBound valueBound : currentBounds = this.getValueBounds()) {
            if (null == valueBound || valueBound.isValueInRange(testedValue)) continue;
            return valueBound;
        }
        return null;
    }

    public void setValue(Amount<Q> newValue) {
        if (null == newValue) {
            return;
        }
        this.value = newValue;
        this.setInputText(this.getFormattedValueFor(newValue));
    }

    public Amount<Q> getValue() {
        this.resynchronizeWithInput();
        return this.value;
    }

    protected void resynchronizeWithInput() {
        if (this.hasSource()) {
            try {
                this.ensureSource();
                this.value = this.parseFromInput();
            }
            catch (NumberFormatException e) {
                this.swallow(e);
            }
        }
    }

    protected boolean isInputTextParseable() {
        try {
            this.parseFromInput();
            return true;
        }
        catch (NumberFormatException e) {
            Parameter.isPresent(e);
            return false;
        }
    }

    protected Amount<Q> parseFromInput() throws NumberFormatException {
        return Amount.valueOf((double)Double.parseDouble(this.retrieveParseableSourceText()), this.getUnit());
    }

    private void ensureSource() throws NumberFormatException {
        if (null == this.getSource()) {
            throw new NumberFormatException(Localisation.getLocalizedString("errormessage.noboundinput"));
        }
    }

    protected String retrieveParseableSourceText() {
        String textualRepresentation = this.getSource().getText();
        if (GlobalInputFrameworkOptions.isCommaConversionEnabled()) {
            textualRepresentation = textualRepresentation.replace(',', '.');
        }
        return textualRepresentation;
    }

    private Double getNumericValue() {
        this.resynchronizeWithInput();
        return this.value.doubleValue(this.getUnit());
    }

    private void swallow(Throwable e) {
        e.hashCode();
    }
}

