/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.types;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.input.datatypes.EmailAddress;
import com.schneide.base.input.datatypes.EmailFormatException;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.TextfieldInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.generic.ValueBase;
import com.schneide.base.input.types.i18n.EmptyValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.input.validation.InvalidInputResult;
import com.schneide.base.input.validation.ValidInputResult;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.programming.NotYetImplementedException;

public class EmailValue
extends ValueBase {
    private EmailAddress lastValue;

    public EmailValue() {
        this(new EmptyValueInformation());
    }

    public EmailValue(ValueInformation information) {
        this(information, "");
    }

    public EmailValue(ValueInformation information, String originalValue) {
        super(information, originalValue);
        if (originalValue != null) {
            try {
                this.lastValue = new EmailAddress(originalValue);
            }
            catch (EmailFormatException e) {
                this.getLogger().warn("Wrong format.", e);
            }
        }
    }

    @Override
    protected Iterable<ValidationResult> internalValidation() {
        if (!EmailAddress.isValidString(this.getSource().getText())) {
            return new SingleElementIterable<ValidationResult>(new InvalidInputResult(this.getSource(), Localisation.getLocalizedText("value.email.error.invalidInput")));
        }
        return new SingleElementIterable<ValidationResult>(new ValidInputResult(this.getSource()));
    }

    public EmailAddress getAddress() {
        return this.getValue();
    }

    public EmailAddress getValue() {
        return this.getValue(false);
    }

    public EmailAddress getValue(boolean internalAccess) throws EmailFormatException {
        try {
            this.ensureSource();
            this.lastValue = new EmailAddress(this.getSource().getText());
            return this.lastValue;
        }
        catch (EmailFormatException e) {
            if (internalAccess) {
                throw e;
            }
            return this.lastValue;
        }
    }

    private void ensureSource() throws EmailFormatException {
        if (this.getSource() == null) {
            throw new EmailFormatException(Localisation.getLocalizedString("errormessage.noboundinput"));
        }
    }

    @Override
    public String getRestrictionDescription() {
        return Localisation.getLocalizedString("value.email.input.description");
    }

    @Override
    public String getUnitString() {
        return "";
    }

    public void setValue(EmailAddress value) {
        this.setOriginalValueIfNoSource(value);
        this.setInputText(value.getAddress());
    }

    @Override
    protected String getCurrentValueRepresentation() {
        return String.valueOf(this.getValue());
    }

    @Override
    public String getTextualValue() {
        StringBuffer result = new StringBuffer();
        result.append(this.getValue());
        return result.toString();
    }

    @Override
    @Deprecated
    public Input createNaturalInput() {
        return new TextfieldInput(this);
    }

    @Override
    public Input createNaturalInput(InputFactory factory) {
        throw new NotYetImplementedException("createNaturalInput");
    }
}

