/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.types;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.input.datatypes.DoubleValueRange;
import com.schneide.base.input.global.GlobalInputFrameworkOptions;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.TextfieldInput;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.types.generic.NumericValue;
import com.schneide.base.input.types.generic.ValueBase;
import com.schneide.base.input.types.i18n.EmptyValueInformation;
import com.schneide.base.input.types.i18n.ValueInformation;
import com.schneide.base.input.validation.InvalidInputResult;
import com.schneide.base.input.validation.ValidInputResult;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.util.Parameter;
import java.text.DecimalFormat;

public class DoubleValue
extends ValueBase
implements NumericValue {
    private final DoubleValueRange bounds;
    private DecimalFormat formatter = null;
    private final String unitString;
    private Double lastValue;

    public DoubleValue() {
        this(new EmptyValueInformation());
    }

    public DoubleValue(ValueInformation valueInformation) {
        this(valueInformation, null, DoubleValueRange.DEFAULT_RANGE, null);
    }

    public DoubleValue(ValueInformation valueInformation, Double originalValue) {
        this(valueInformation, originalValue, (String)null);
    }

    public DoubleValue(ValueInformation valueInformation, String unitString) {
        this(valueInformation, null, DoubleValueRange.DEFAULT_RANGE, unitString);
    }

    public DoubleValue(ValueInformation valueInformation, Double originalValue, String unitString) {
        this(valueInformation, originalValue, DoubleValueRange.DEFAULT_RANGE, unitString);
    }

    public DoubleValue(ValueInformation valueInformation, DoubleValueRange valueRange) {
        this(valueInformation, null, valueRange, null);
    }

    public DoubleValue(ValueInformation valueInformation, double originalValue, DoubleValueRange valueRange) {
        this(valueInformation, originalValue, valueRange, null);
    }

    public DoubleValue(ValueInformation valueInformation, Double originalValue, DoubleValueRange valueRange) {
        this(valueInformation, originalValue, valueRange, null);
    }

    public DoubleValue(ValueInformation valueInformation, DoubleValueRange valueRange, String unitString) {
        this(valueInformation, null, valueRange, unitString);
    }

    public DoubleValue(ValueInformation valueInformation, Double originalValue, DoubleValueRange valueRange, String unitString) {
        super(valueInformation, originalValue);
        this.bounds = valueRange;
        this.unitString = ValueBase.determineUnit(valueInformation, unitString);
        if (this.hasOriginalValue()) {
            this.lastValue = originalValue;
        }
    }

    @Override
    public String getRestrictionDescription() {
        StringBuilder result = new StringBuilder();
        result.append(Localisation.getLocalizedString("value.abstractDouble.input.description"));
        result.append(this.bounds.getIntuitiveDescription());
        return result.toString();
    }

    public boolean isValueInRange(double value) {
        return this.bounds.isValueInRange(value);
    }

    public String getValueRangeDescription() {
        return this.bounds.getFullDescription();
    }

    public double getLowerBound() {
        return this.bounds.getLowerBound();
    }

    public DoubleValueRange getBounds() {
        return this.bounds;
    }

    public double getUpperBound() {
        return this.bounds.getUpperBound();
    }

    @Override
    public boolean hasLowerBound() {
        return this.bounds.hasLowerRestriction();
    }

    @Override
    public boolean hasUpperBound() {
        return this.bounds.hasUpperRestriction();
    }

    public void setValue(double value) {
        this.setValue(value, this.getFormatter());
    }

    public void setValue(double value, DecimalFormat currentFormatter) {
        this.setOriginalValueIfNoSource(value);
        this.setInputText(this.getFormattedValue(value, currentFormatter));
    }

    protected final void ensureSource() throws NumberFormatException {
        if (null == this.getSource()) {
            throw new NumberFormatException(Localisation.getLocalizedString("errormessage.noboundinput"));
        }
    }

    protected final String getFormattedValue(double value, DecimalFormat currentFormatter) {
        if (null == currentFormatter) {
            return String.valueOf(value);
        }
        return currentFormatter.format(value);
    }

    public boolean hasFormatter() {
        return this.getFormatter() != null;
    }

    public DecimalFormat getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DecimalFormat formatter) {
        this.formatter = formatter;
    }

    @Override
    protected Iterable<ValidationResult> internalValidation() {
        try {
            this.lastValue = this.getValue(true);
            if (this.isValueInRange(this.lastValue)) {
                return new SingleElementIterable<ValidationResult>(new ValidInputResult(this.getSource()));
            }
            return new SingleElementIterable<ValidationResult>(new InvalidInputResult(this.getSource(), new DirectText(Localisation.getLocalizedString("value.error.rangeExceeded") + this.getValueRangeDescription())));
        }
        catch (NumberFormatException e) {
            Parameter.isPresent(e);
            return new SingleElementIterable<ValidationResult>(new InvalidInputResult(this.getSource(), Localisation.getLocalizedText("value.double.error.invalidInput")));
        }
    }

    public double getValue() {
        return this.getValue(false);
    }

    private String retrieveParseableSourceText() {
        String textualRepresentation = this.getSource().getText();
        if (GlobalInputFrameworkOptions.isCommaConversionEnabled()) {
            textualRepresentation = textualRepresentation.replace(',', '.');
        }
        return textualRepresentation;
    }

    /*
     * Unable to fully structure code
     */
    public double getValue(boolean internalAccess) throws NumberFormatException {
        if (this.hasSource()) {
            try {
                this.ensureSource();
                this.lastValue = Double.parseDouble(this.retrieveParseableSourceText());
            }
            catch (NumberFormatException e) {
                if (!internalAccess) ** GOTO lbl10
                throw e;
            }
        } else {
            this.lastValue = (Double)this.getOriginalValue();
        }
lbl10:
        // 3 sources

        if (this.lastValue == null) {
            if (internalAccess) {
                throw new NumberFormatException();
            }
            return 0.0;
        }
        return this.lastValue;
    }

    @Override
    public String getUnitString() {
        return this.unitString;
    }

    @Override
    protected String getCurrentValueRepresentation() {
        return this.getTextualValue();
    }

    @Override
    public String getTextualValue() {
        try {
            return this.getFormattedValue(this.getValue(true), this.getFormatter());
        }
        catch (Exception e) {
            Parameter.isPresent(e);
            return null;
        }
    }

    @Override
    @Deprecated
    public Input createNaturalInput() {
        return new TextfieldInput(this);
    }

    @Override
    public Input createNaturalInput(InputFactory factory) {
        return new TextfieldInput(this);
    }
}

