/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs.generic;

import com.schneide.base.input.inputs.generic.ColumnEnabledJComponent;
import com.schneide.base.input.types.generic.Value;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;

public class InputColumnHandler {
    private static final int MINIMAL_COLUMNS = 8;
    private final ColumnEnabledJComponent component;
    private int columns;
    private int columnWidth;

    public InputColumnHandler(ColumnEnabledJComponent component, int columns) {
        this.component = component;
        this.columnWidth = 0;
        this.columns = Math.max(0, columns);
    }

    public static int calculateColumnsFor(Value value) {
        String textualValue;
        int valueLength = 0;
        if (null != value && null != (textualValue = value.getTextualValue())) {
            valueLength = textualValue.length();
        }
        return Math.max(8, valueLength);
    }

    private ColumnEnabledJComponent getComponent() {
        return this.component;
    }

    protected int getCurrentlyNeededWidth() {
        return Math.min(this.getColumns() * this.getColumnWidth(), this.getComponent().getFontMetrics(this.getComponent().getFont()).stringWidth(this.getComponent().getText()));
    }

    public Dimension getPreferredSize() {
        Dimension size = this.getComponent().getComponentPreferredSize();
        if (this.getColumns() != 0) {
            Insets insets = this.getComponent().getInsets();
            size.width = this.getCurrentlyNeededWidth() + insets.left + insets.right;
        }
        return size;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException("columns must not be negative.");
        }
        int oldColumns = this.getColumns();
        this.columns = columns;
        if (columns != oldColumns) {
            this.getComponent().invalidate();
        }
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getComponent().getFontMetrics(this.getComponent().getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }
}

