/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs.generic;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.input.global.GlobalInputFrameworkOptions;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.IgnoredInputResult;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.text.transformation.Embrace;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GenericInputImplementation
implements DocumentListener,
ChangeListener,
ActionListener {
    private final Input parent;
    private final Value value;
    private boolean realtimeSupervision;
    private boolean isIgnoringDocumentEvent;

    public GenericInputImplementation(Input parent, Value value, JComponent swingComponent) {
        this.parent = parent;
        this.value = value;
        swingComponent.setName(this.value.getTitle());
        this.realtimeSupervision = false;
    }

    public String getTitleText() {
        return this.getTitleText(GlobalInputFrameworkOptions.isUnitIntegratedInTitle());
    }

    public String getTitleText(boolean withUnit) {
        StringBuilder result = new StringBuilder();
        result.append(this.getTitle());
        if (withUnit && this.hasUnitDenotation()) {
            result.append(" ");
            result.append(Embrace.withSquareBrackets(this.getUnitDenotation()));
        }
        result.append(":");
        return result.toString();
    }

    private boolean hasUnitDenotation() {
        return this.getValue().hasUnitString();
    }

    public String getTitle() {
        return this.getValue().getTitle();
    }

    public String getUnitDenotation() {
        return this.getValue().getUnitString();
    }

    public JLabel createBoundLabel(String string) {
        JLabel result = new JLabel(string);
        result.setLabelFor(this.getParent().getInputComponent());
        result.setToolTipText(this.getDescription());
        return result;
    }

    public JLabel createDefaultTitleLabel() {
        return this.createBoundLabel(this.getTitleText());
    }

    public JLabel getUnitLabel() {
        if (GlobalInputFrameworkOptions.isUnitIntegratedInTitle()) {
            return this.createBoundLabel("");
        }
        return this.createBoundLabel(this.getUnitDenotation());
    }

    public Iterable<ValidationResult> validateInput() {
        if (null != this.getValue()) {
            return this.getValue().validate();
        }
        return new SingleElementIterable<ValidationResult>(new IgnoredInputResult(this.getParent()));
    }

    private Input getParent() {
        return this.parent;
    }

    private Value getValue() {
        return this.value;
    }

    public Value getBoundValue() {
        return this.getValue();
    }

    public String getDescription() {
        return this.getValue().getFullDescription();
    }

    public JComponent getInputComponent() {
        return this.getParent().getInputComponent();
    }

    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        layoutStrategy.addTo(panel, this.getParent().getTitleLabel(), this.getInputComponent(), this.getUnitLabel());
    }

    public boolean isRealtimeSupervised() {
        return this.realtimeSupervision;
    }

    public void setRealtimeSupervision(boolean state) {
        if (this.isRealtimeSupervised() != state) {
            if (state) {
                this.getParent().addValueChangeSource();
            } else {
                this.getParent().removeValueChangeSource();
            }
            this.realtimeSupervision = state;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        if (!this.isIgnoringDocumentEvent()) {
            this.notifyNewValue();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        if (!this.isIgnoringDocumentEvent()) {
            this.notifyNewValue();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        if (!this.isIgnoringDocumentEvent()) {
            this.notifyNewValue();
        }
    }

    public void setIgnoreDocumentEvents(boolean ignoreState) {
        this.isIgnoringDocumentEvent = ignoreState;
    }

    public boolean isIgnoringDocumentEvent() {
        return this.isIgnoringDocumentEvent;
    }

    public void notifyNewValue() {
        Iterable<ValidationResult> validationResults = this.validateInput();
        this.parent.setValidationResults(validationResults);
        if (this.isRealtimeSupervised() && null != this.value) {
            this.value.notifyValueChanged();
        }
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        this.notifyNewValue();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.notifyNewValue();
    }

    public void showRequired(boolean isRequired) {
        this.showRequired(isRequired, () -> this.getInputComponent());
    }

    public void showRequired(boolean isRequired, Supplier<JComponent> target) {
        EDT.perform(() -> {
            if (isRequired) {
                ((JComponent)target.get()).setBackground(this.requiredColorFor((JComponent)target.get()));
            }
        });
    }

    private Color requiredColorFor(JComponent target) {
        Color background = target.getBackground();
        return new Color(255, Math.max(0, background.getGreen() - 26), Math.max(0, background.getBlue() - 26));
    }
}

