/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs;

import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.generic.BoundAwareInput;
import com.schneide.base.input.inputs.generic.ColumnAwareInput;
import com.schneide.base.input.inputs.generic.GenericInputImplementation;
import com.schneide.base.input.inputs.generic.InputColumnHandler;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.modes.TextualBasedInput;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.text.Text;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.border.Border;

public class TextfieldInput
extends JTextField
implements ColumnAwareInput,
TextualBasedInput,
BoundAwareInput {
    private static final long serialVersionUID = -625323491879507252L;
    private final GenericInputImplementation inputImplementation;
    private final Border defaultBorder;
    private Iterable<ValidationResult> currentValidationResults;

    public TextfieldInput(Value value) {
        this(value, InputColumnHandler.calculateColumnsFor(value));
    }

    public TextfieldInput(Value value, int columns) {
        this.setColumns(columns);
        this.inputImplementation = new GenericInputImplementation(this, value, this);
        this.defaultBorder = this.getBorder();
        this.currentValidationResults = new EmptyIterable<ValidationResult>();
        if (Text.hasContent(value.getTextualValue())) {
            this.setInputText(value.getTextualValue());
        } else if (value.getOriginalValue() != null) {
            this.setInputText(String.valueOf(value.getOriginalValue()));
        }
        value.setSource(this);
        this.adjustTooltip();
    }

    public void adjustTooltip() {
        if (this.getImplementation() != null) {
            this.setToolTipText(this.getImplementation().getDescription());
        }
    }

    @Override
    public void adjustBounds() {
        this.adjustTooltip();
    }

    @Override
    public JLabel getTitleLabel() {
        return this.getImplementation().createDefaultTitleLabel();
    }

    @Override
    public String getTitle() {
        return this.getImplementation().getTitle();
    }

    @Override
    public String getUnit() {
        return this.getImplementation().getUnitDenotation();
    }

    private GenericInputImplementation getImplementation() {
        return this.inputImplementation;
    }

    @Override
    public JLabel getUnitLabel() {
        return this.getImplementation().getUnitLabel();
    }

    @Override
    public Iterable<ValidationResult> validateInput() {
        return this.getImplementation().validateInput();
    }

    @Override
    public Value getBoundValue() {
        return this.getImplementation().getBoundValue();
    }

    @Override
    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        this.getImplementation().addToPanel(panel, layoutStrategy);
    }

    @Override
    public JComponent getInputComponent() {
        return this;
    }

    @Override
    public void setInputText(String text) {
        if (null == text) {
            return;
        }
        if (this.getText().equals(text)) {
            return;
        }
        this.changeInputText(text);
    }

    protected void changeInputText(String text) {
        int caretPosition = this.getCaretPosition();
        this.getImplementation().setIgnoreDocumentEvents(true);
        super.setText(text);
        this.getImplementation().setIgnoreDocumentEvents(false);
        if (this.getImplementation().isRealtimeSupervised()) {
            this.getImplementation().notifyNewValue();
        }
        caretPosition = Math.min(caretPosition, text.length());
        this.setCaretPosition(caretPosition);
    }

    @Override
    public void setRealtimeSupervision(boolean enabled) {
        this.getImplementation().setRealtimeSupervision(enabled);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip toolTip = super.createToolTip();
        for (ValidationResult result : this.currentValidationResults) {
            if (!result.needsDisplay()) continue;
            toolTip.setBackground(Color.RED);
        }
        return toolTip;
    }

    @Override
    public void setValidationResults(Iterable<ValidationResult> validationResults) {
        this.currentValidationResults = validationResults;
        for (ValidationResult result : validationResults) {
            if (result.needsDisplay()) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.RED, 2), this.defaultBorder));
                this.setToolTipText(result.getMessage());
                continue;
            }
            this.setBorder(this.defaultBorder);
            this.adjustTooltip();
        }
    }

    @Override
    public void addValueChangeSource() {
        this.getDocument().addDocumentListener(this.getImplementation());
    }

    @Override
    public void removeValueChangeSource() {
        this.getDocument().removeDocumentListener(this.getImplementation());
    }

    @Override
    public String getActionDescription() {
        return Localisation.getLocalizedString("input.textfield.action.description");
    }

    @Override
    public boolean canBeEdited() {
        return this.isEditable() && this.isEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.adjustTooltip();
    }

    @Override
    public void setEditable(boolean state) {
        super.setEditable(state);
        this.adjustTooltip();
    }

    @Override
    public void refreshFromValue() {
    }

    @Override
    public void showRequired(boolean isRequired) {
        this.inputImplementation.showRequired(isRequired);
    }
}

