/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs;

import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.data.DefaultTextareaDimension;
import com.schneide.base.input.inputs.data.TextareaDimension;
import com.schneide.base.input.inputs.generic.BoundAwareInput;
import com.schneide.base.input.inputs.generic.ColumnAwareInput;
import com.schneide.base.input.inputs.generic.GenericInputImplementation;
import com.schneide.base.input.inputs.generic.InputColumnHandler;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.modes.TextualBasedInput;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.util.Parameter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class TextareaInput
extends JTextArea
implements ColumnAwareInput,
TextualBasedInput,
BoundAwareInput {
    private static final long serialVersionUID = 809148513831359797L;
    private final GenericInputImplementation inputImplementation;
    private final JScrollPane providedComponent;

    public TextareaInput(Value value) {
        this(value, new DefaultTextareaDimension(InputColumnHandler.calculateColumnsFor(value)));
    }

    public TextareaInput(Value value, TextareaDimension dimension) {
        Parameter.arePresent(value, dimension);
        this.setBorder(this.getDefaultBorder());
        this.setDimension(dimension);
        this.inputImplementation = new GenericInputImplementation(this, value, this);
        value.setSource(this);
        if (value.getOriginalValue() != null) {
            this.setInputText(value.getOriginalValue().toString());
        }
        this.adjustTooltip();
        this.providedComponent = new JScrollPane(this);
        this.providedComponent.setName("scroll-for-" + this.getName());
    }

    protected Border getDefaultBorder() {
        return new JTextField().getBorder();
    }

    public void setDimension(TextareaDimension dimension) {
        if (dimension.hasColumns()) {
            this.setColumns(dimension.getColumns());
        }
        if (dimension.hasRows()) {
            this.setRows(dimension.getRows());
        }
    }

    @Override
    public void setValidationResults(Iterable<ValidationResult> validationResults) {
    }

    public void adjustTooltip() {
        if (this.getImplementation() != null) {
            this.setToolTipText(this.getImplementation().getDescription());
        }
    }

    @Override
    public void adjustBounds() {
        this.adjustTooltip();
    }

    @Override
    public JLabel getTitleLabel() {
        return this.getImplementation().createDefaultTitleLabel();
    }

    @Override
    public String getTitle() {
        return this.getImplementation().getTitle();
    }

    @Override
    public String getUnit() {
        return this.getImplementation().getUnitDenotation();
    }

    @Override
    public JLabel getUnitLabel() {
        return this.getImplementation().getUnitLabel();
    }

    private GenericInputImplementation getImplementation() {
        return this.inputImplementation;
    }

    @Override
    public Iterable<ValidationResult> validateInput() {
        return this.getImplementation().validateInput();
    }

    @Override
    public Value getBoundValue() {
        return this.getImplementation().getBoundValue();
    }

    @Override
    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        this.getImplementation().addToPanel(panel, layoutStrategy);
    }

    @Override
    public JComponent getInputComponent() {
        return this.providedComponent;
    }

    @Override
    public void setInputText(String text) {
        int caretPosition = this.getCaretPosition();
        super.setText(text);
        this.setCaretPosition(Math.min(caretPosition, this.getText().length()));
    }

    @Override
    public void setRealtimeSupervision(boolean enabled) {
        this.getImplementation().setRealtimeSupervision(enabled);
    }

    @Override
    public void addValueChangeSource() {
        this.getDocument().addDocumentListener(this.getImplementation());
    }

    @Override
    public void removeValueChangeSource() {
        this.getDocument().removeDocumentListener(this.getImplementation());
    }

    @Override
    public String getActionDescription() {
        return Localisation.getLocalizedString("input.textarea.action.description");
    }

    @Override
    public boolean canBeEdited() {
        return this.isEditable() && this.isEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.adjustTooltip();
    }

    @Override
    public void setEditable(boolean state) {
        super.setEditable(state);
        this.adjustTooltip();
    }

    @Override
    public void refreshFromValue() {
    }

    @Override
    public void showRequired(boolean isRequired) {
        this.inputImplementation.showRequired(isRequired);
    }
}

