/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs;

import com.schneide.base.input.datatypes.DoubleValueRange;
import com.schneide.base.input.datatypes.IntegerValueRange;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.generic.BoundAwareInput;
import com.schneide.base.input.inputs.generic.GenericInputImplementation;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.modes.TextualBasedInput;
import com.schneide.base.input.types.DoubleValue;
import com.schneide.base.input.types.IntegerValue;
import com.schneide.base.input.types.generic.NumericValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.ValidationResult;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class SliderInput
extends JSlider
implements Input,
TextualBasedInput,
BoundAwareInput {
    private static final long serialVersionUID = 815147459814277526L;
    private final GenericInputImplementation inputImplementation;
    private final double resolutionFactor;

    public SliderInput(DoubleValue value) {
        this(value, 3);
    }

    public SliderInput(DoubleValue value, int precision) {
        this(value, value.getBounds(), precision);
    }

    private SliderInput(DoubleValue value, DoubleValueRange range, int precision) {
        this(value, range, SliderInput.calculateResolutionFactor(precision));
    }

    private SliderInput(DoubleValue value, DoubleValueRange range, double resolutionFactor) {
        this((NumericValue)value, SliderInput.createIntegerRangeFrom(range, resolutionFactor), resolutionFactor);
    }

    private static double calculateResolutionFactor(int precision) {
        return Math.pow(10.0, precision);
    }

    private static IntegerValueRange createIntegerRangeFrom(DoubleValueRange range, double resolutionFactor) {
        return new IntegerValueRange((int)(range.getLowerBound() * resolutionFactor), (int)(range.getUpperBound() * resolutionFactor));
    }

    public SliderInput(IntegerValue value) {
        this(value, value.getBounds());
    }

    private SliderInput(IntegerValue value, IntegerValueRange range) {
        this(value, range, 1.0);
        this.setValue(value.getValue());
    }

    private SliderInput(NumericValue value, IntegerValueRange range, double resolutionFactor) {
        super(range.getLowerBound(), range.getUpperBound());
        this.ensureIsDoubleBounded(range);
        this.resolutionFactor = resolutionFactor;
        this.inputImplementation = new GenericInputImplementation(this, value, this);
        value.setSource(this);
        this.adjustTooltip();
    }

    private void ensureIsDoubleBounded(IntegerValueRange range) {
        if (!range.hasLowerRestriction() || !range.hasUpperRestriction()) {
            throw new IllegalArgumentException("The value has to be bounded (value restricted)");
        }
    }

    @Override
    public void setValidationResults(Iterable<ValidationResult> validationResults) {
    }

    public void adjustTooltip() {
        if (this.getImplementation() != null) {
            this.setToolTipText(this.getImplementation().getDescription());
        }
    }

    @Override
    public void adjustBounds() {
        this.adjustTooltip();
        if (this.getImplementation().getBoundValue() instanceof IntegerValue) {
            this.adjustBoundsForIntegerValue((IntegerValue)this.getImplementation().getBoundValue());
        }
    }

    private void adjustBoundsForIntegerValue(IntegerValue value) {
        this.ensureIsDoubleBounded(value.getBounds());
        this.setMinimum(value.getLowerBound());
        this.setMaximum(value.getUpperBound());
    }

    @Override
    public JLabel getTitleLabel() {
        return this.getImplementation().createDefaultTitleLabel();
    }

    private GenericInputImplementation getImplementation() {
        return this.inputImplementation;
    }

    @Override
    public String getTitle() {
        return this.getImplementation().getTitle();
    }

    @Override
    public String getUnit() {
        return this.getImplementation().getUnitDenotation();
    }

    @Override
    public JLabel getUnitLabel() {
        return this.getImplementation().getUnitLabel();
    }

    @Override
    public Iterable<ValidationResult> validateInput() {
        return this.getImplementation().validateInput();
    }

    @Override
    public Value getBoundValue() {
        return this.getImplementation().getBoundValue();
    }

    @Override
    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        this.getImplementation().addToPanel(panel, layoutStrategy);
    }

    @Override
    public JComponent getInputComponent() {
        return this;
    }

    @Override
    public void setInputText(String text) {
        if (text != null) {
            double value = Double.parseDouble(text) * this.resolutionFactor;
            this.setValue((int)value);
        }
    }

    @Override
    public void setRealtimeSupervision(boolean enabled) {
        this.getImplementation().setRealtimeSupervision(enabled);
    }

    @Override
    public boolean canBeEdited() {
        return false;
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.adjustTooltip();
    }

    @Override
    public void addValueChangeSource() {
    }

    @Override
    public String getActionDescription() {
        return Localisation.getLocalizedString("input.label.action.description");
    }

    @Override
    public void removeValueChangeSource() {
    }

    @Override
    public String getText() {
        return String.valueOf((double)this.getValue() / this.resolutionFactor);
    }

    @Override
    public void refreshFromValue() {
    }

    @Override
    public void showRequired(boolean isRequired) {
    }
}

