/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs;

import com.schneide.base.input.datatypes.IntegerValueRange;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.generic.BoundAwareInput;
import com.schneide.base.input.inputs.generic.GenericInputImplementation;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.modes.TextualBasedInput;
import com.schneide.base.input.types.IntegerValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.ValidationResult;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressbarInput
extends JProgressBar
implements Input,
TextualBasedInput,
BoundAwareInput {
    private static final long serialVersionUID = 1751004198829714805L;
    private final GenericInputImplementation inputImplementation;

    public ProgressbarInput(IntegerValue value) {
        this.adjustBoundsForIntegerValue(value);
        this.inputImplementation = new GenericInputImplementation(this, value, this);
        value.setSource(this);
        this.setValue(value.getValue());
        this.adjustTooltip();
    }

    private void ensureIsDoubleBounded(IntegerValueRange range) {
        if (!range.hasLowerRestriction() || !range.hasUpperRestriction()) {
            throw new IllegalArgumentException("Der Wert muss eingeschr\u00e4nkt sein.");
        }
    }

    @Override
    public void setValidationResults(Iterable<ValidationResult> validationResults) {
    }

    public void adjustTooltip() {
        if (this.getImplementation() != null) {
            this.setToolTipText(this.getImplementation().getDescription());
        }
    }

    @Override
    public void adjustBounds() {
        this.adjustTooltip();
        if (this.getImplementation().getBoundValue() instanceof IntegerValue) {
            this.adjustBoundsForIntegerValue((IntegerValue)this.getImplementation().getBoundValue());
        }
    }

    private void adjustBoundsForIntegerValue(IntegerValue value) {
        this.ensureIsDoubleBounded(value.getBounds());
        this.setMinimum(value.getLowerBound());
        this.setMaximum(value.getUpperBound());
    }

    @Override
    public JLabel getTitleLabel() {
        return this.getImplementation().createDefaultTitleLabel();
    }

    @Override
    public String getTitle() {
        return this.getImplementation().getTitle();
    }

    @Override
    public String getUnit() {
        return this.getImplementation().getUnitDenotation();
    }

    private GenericInputImplementation getImplementation() {
        return this.inputImplementation;
    }

    @Override
    public JLabel getUnitLabel() {
        return this.getImplementation().getUnitLabel();
    }

    @Override
    public Iterable<ValidationResult> validateInput() {
        return this.getImplementation().validateInput();
    }

    @Override
    public Value getBoundValue() {
        return this.getImplementation().getBoundValue();
    }

    @Override
    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        this.getImplementation().addToPanel(panel, layoutStrategy);
    }

    @Override
    public JComponent getInputComponent() {
        return this;
    }

    @Override
    public void setInputText(String text) {
        this.setString(text);
    }

    @Override
    public void setRealtimeSupervision(boolean enabled) {
        this.getImplementation().setRealtimeSupervision(enabled);
    }

    @Override
    public boolean canBeEdited() {
        return false;
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.adjustTooltip();
    }

    @Override
    public void addValueChangeSource() {
    }

    @Override
    public String getActionDescription() {
        return Localisation.getLocalizedString("input.label.action.description");
    }

    @Override
    public void removeValueChangeSource() {
    }

    @Override
    public String getText() {
        return this.getString();
    }

    @Override
    public void refreshFromValue() {
    }

    @Override
    public void showRequired(boolean isRequired) {
    }
}

