/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs;

import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.generic.BoundAwareInput;
import com.schneide.base.input.inputs.generic.ColumnAwareInput;
import com.schneide.base.input.inputs.generic.ColumnEnabledJComponent;
import com.schneide.base.input.inputs.generic.GenericInputImplementation;
import com.schneide.base.input.inputs.generic.InputColumnHandler;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.modes.TextualBasedInput;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.ValidationResult;
import com.schneide.base.text.Text;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabelInput
extends JLabel
implements ColumnAwareInput,
TextualBasedInput,
ColumnEnabledJComponent,
BoundAwareInput {
    private static final long serialVersionUID = 8804964369826952157L;
    private final GenericInputImplementation inputImplementation;
    private final InputColumnHandler columnHandler;
    private boolean hasBoldFont;

    public LabelInput(Value value) {
        this(value, InputColumnHandler.calculateColumnsFor(value));
    }

    public LabelInput(Value value, int columns) {
        this.setName(value.getTitle());
        this.columnHandler = new InputColumnHandler(this, columns);
        this.inputImplementation = new GenericInputImplementation(this, value, this);
        this.hasBoldFont = false;
        value.setSource(this);
        if (Text.hasContent(value.getTextualValue())) {
            this.setInputText(value.getTextualValue());
        }
        if (!value.hasValue()) {
            this.setInputText("");
        }
        this.adjustTooltip();
    }

    @Override
    public void setValidationResults(Iterable<ValidationResult> validationResults) {
    }

    public void adjustTooltip() {
        if (this.getImplementation() != null) {
            this.setToolTipText(this.getImplementation().getDescription());
        }
    }

    @Override
    public void adjustBounds() {
        this.adjustTooltip();
    }

    public void setBoldFont(boolean state) {
        this.hasBoldFont = state;
        this.adjustBoldness(this);
    }

    @Override
    public JLabel getTitleLabel() {
        JLabel result = this.getImplementation().createDefaultTitleLabel();
        return this.adjustBoldness(result);
    }

    protected JLabel adjustBoldness(JLabel label) {
        label.setFont(label.getFont().deriveFont(this.getFontStyle()));
        return label;
    }

    protected int getFontStyle() {
        if (this.hasBoldFont) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getTitle() {
        return this.getImplementation().getTitle();
    }

    @Override
    public JLabel getUnitLabel() {
        JLabel result = this.getImplementation().getUnitLabel();
        return this.adjustBoldness(result);
    }

    @Override
    public Iterable<ValidationResult> validateInput() {
        return this.getImplementation().validateInput();
    }

    @Override
    public Value getBoundValue() {
        return this.getImplementation().getBoundValue();
    }

    @Override
    public String getUnit() {
        return this.getImplementation().getUnitDenotation();
    }

    private GenericInputImplementation getImplementation() {
        return this.inputImplementation;
    }

    @Override
    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        this.getImplementation().addToPanel(panel, layoutStrategy);
    }

    @Override
    public JComponent getInputComponent() {
        return this;
    }

    @Override
    public void setInputText(String text) {
        super.setText(text);
    }

    @Override
    public void setRealtimeSupervision(boolean enabled) {
        this.getImplementation().setRealtimeSupervision(enabled);
    }

    @Override
    public void addValueChangeSource() {
    }

    @Override
    public void removeValueChangeSource() {
    }

    @Override
    public String getActionDescription() {
        return Localisation.getLocalizedString("input.label.action.description");
    }

    @Override
    public boolean canBeEdited() {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.columnHandler.getPreferredSize();
    }

    @Override
    public Dimension getComponentPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public int getColumns() {
        return this.columnHandler.getColumns();
    }

    @Override
    public void setColumns(int columns) {
        this.columnHandler.setColumns(columns);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.adjustTooltip();
    }

    @Override
    public void refreshFromValue() {
    }

    @Override
    public void showRequired(boolean isRequired) {
    }
}

