/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs;

import com.schneide.base.input.inputs.CheckboxInput;
import com.schneide.base.input.inputs.ComboboxInput;
import com.schneide.base.input.inputs.PasswordInput;
import com.schneide.base.input.inputs.SpinnerInput;
import com.schneide.base.input.inputs.TextfieldInput;
import com.schneide.base.input.inputs.time.DayChooserInput;
import com.schneide.base.input.inputs.touchscreen.TouchscreenComboboxInput;
import com.schneide.base.input.inputs.touchscreen.TouchscreenDayChooserInput;
import com.schneide.base.input.inputs.touchscreen.TouchscreenTextfieldInput;
import com.schneide.base.input.types.AssociationValue;
import com.schneide.base.input.types.BooleanValue;
import com.schneide.base.input.types.DateValue;
import com.schneide.base.input.types.IntegerValue;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.programming.NotYetImplementedException;

public interface InputFactory {
    public ComboboxInput getComboboxInputFor(Value var1);

    public ComboboxInput getComboboxInputFor(AssociationValue<?> var1);

    public ComboboxInput getComboboxInputFor(BooleanValue var1);

    public CheckboxInput getCheckboxInputFor(Value var1);

    public TextfieldInput getTextfieldInputFor(Value var1);

    public TextfieldInput getTextfieldInputFor(Value var1, int var2);

    public PasswordInput getPasswordInputFor(Value var1);

    public SpinnerInput getSpinnerInputFor(IntegerValue var1);

    public DayChooserInput getDayChooserInputFor(DateValue var1);

    public static class TouchscreenInputFactory
    implements InputFactory {
        @Override
        public ComboboxInput getComboboxInputFor(Value value) {
            return new TouchscreenComboboxInput(value);
        }

        @Override
        public ComboboxInput getComboboxInputFor(AssociationValue<?> value) {
            return new TouchscreenComboboxInput(value);
        }

        @Override
        public ComboboxInput getComboboxInputFor(BooleanValue value) {
            return new TouchscreenComboboxInput(value);
        }

        @Override
        public CheckboxInput getCheckboxInputFor(Value value) {
            throw new NotYetImplementedException("getCheckboxInputFor");
        }

        @Override
        public TextfieldInput getTextfieldInputFor(Value value) {
            return new TouchscreenTextfieldInput(value);
        }

        @Override
        public PasswordInput getPasswordInputFor(Value value) {
            throw new NotYetImplementedException("getPasswordInputFor");
        }

        @Override
        public TextfieldInput getTextfieldInputFor(Value value, int columns) {
            return new TouchscreenTextfieldInput(value, columns);
        }

        @Override
        public SpinnerInput getSpinnerInputFor(IntegerValue value) {
            return new SpinnerInput(value);
        }

        @Override
        public DayChooserInput getDayChooserInputFor(DateValue value) {
            return new TouchscreenDayChooserInput(value);
        }
    }

    public static class DesktopInputFactory
    implements InputFactory {
        @Override
        public ComboboxInput getComboboxInputFor(Value value) {
            return new ComboboxInput(value);
        }

        @Override
        public ComboboxInput getComboboxInputFor(AssociationValue<?> value) {
            return new ComboboxInput(value);
        }

        @Override
        public ComboboxInput getComboboxInputFor(BooleanValue value) {
            return new ComboboxInput(value);
        }

        @Override
        public CheckboxInput getCheckboxInputFor(Value value) {
            return new CheckboxInput(value);
        }

        @Override
        public TextfieldInput getTextfieldInputFor(Value value) {
            return new TextfieldInput(value);
        }

        @Override
        public PasswordInput getPasswordInputFor(Value value) {
            return new PasswordInput(value);
        }

        @Override
        public TextfieldInput getTextfieldInputFor(Value value, int columns) {
            return new TextfieldInput(value, columns);
        }

        @Override
        public SpinnerInput getSpinnerInputFor(IntegerValue value) {
            return new SpinnerInput(value);
        }

        @Override
        public DayChooserInput getDayChooserInputFor(DateValue value) {
            return new DayChooserInput(value);
        }
    }
}

