/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.inputs;

import com.schneide.base.input.global.GlobalInputFrameworkOptions;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.input.inputs.generic.GenericInputImplementation;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.modes.InternalStateBasedInput;
import com.schneide.base.input.types.generic.Value;
import com.schneide.base.input.validation.ValidationResult;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CheckboxInput
extends JCheckBox
implements InternalStateBasedInput {
    private static final long serialVersionUID = -5393238982782733004L;
    private final GenericInputImplementation inputImplementation;
    private final boolean trailingTitled;

    public CheckboxInput(Value value) {
        this(value, GlobalInputFrameworkOptions.isCheckboxTrailingTitled());
    }

    public CheckboxInput(Value value, boolean trailingTitled) {
        this.inputImplementation = new GenericInputImplementation(this, value, this);
        this.trailingTitled = trailingTitled;
        value.setSource(this);
        if (value.getOriginalValue() != null && value.getOriginalValue() instanceof Boolean) {
            this.setSelected((Boolean)value.getOriginalValue());
        }
        this.adjustText();
        this.adjustTooltip();
    }

    private void adjustText() {
        String text = "";
        if (this.isTrailingTitle()) {
            text = this.getTitle();
        }
        this.setText(text);
    }

    public void adjustTooltip() {
        if (this.hasImplementation()) {
            this.setToolTipText(this.getImplementation().getDescription());
        }
    }

    private boolean hasImplementation() {
        return this.getImplementation() != null;
    }

    private GenericInputImplementation getImplementation() {
        return this.inputImplementation;
    }

    private boolean isTrailingTitle() {
        return this.trailingTitled;
    }

    @Override
    public JLabel getTitleLabel() {
        String title = "";
        if (!this.isTrailingTitle()) {
            title = this.getImplementation().getTitleText();
        }
        return this.getImplementation().createBoundLabel(title);
    }

    @Override
    public void setValidationResults(Iterable<ValidationResult> validationResults) {
    }

    @Override
    public String getTitle() {
        return this.getImplementation().getTitle();
    }

    @Override
    public String getUnit() {
        return this.getImplementation().getUnitDenotation();
    }

    @Override
    public JLabel getUnitLabel() {
        return this.getImplementation().getUnitLabel();
    }

    @Override
    public Iterable<ValidationResult> validateInput() {
        return this.getImplementation().validateInput();
    }

    @Override
    public Value getBoundValue() {
        return this.getImplementation().getBoundValue();
    }

    @Override
    public void addToPanel(JPanel panel, LayoutStrategy layoutStrategy) {
        this.getImplementation().addToPanel(panel, layoutStrategy);
    }

    @Override
    public JComponent getInputComponent() {
        this.adjustText();
        return this;
    }

    @Override
    public void setInputText(String text) {
    }

    @Override
    public void setRealtimeSupervision(boolean enabled) {
        this.getImplementation().setRealtimeSupervision(enabled);
    }

    @Override
    public void addValueChangeSource() {
        this.addActionListener(this.getImplementation());
    }

    @Override
    public void removeValueChangeSource() {
        this.removeActionListener(this.getImplementation());
    }

    @Override
    public String getActionDescription() {
        return Localisation.getLocalizedString("input.checkbox.action.description");
    }

    @Override
    public boolean canBeEdited() {
        return this.isEnabled();
    }

    @Override
    public void refreshFromValue() {
    }

    @Override
    public void showRequired(boolean isRequired) {
    }
}

