/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.helper;

import com.schneide.base.input.helper.LayoutSpecification;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.inputs.layout.StringGridBagLayoutStrategy;
import com.schneide.base.layout.GridBagLayoutPanel;
import java.util.Arrays;
import javax.swing.JPanel;

public final class LayoutHelper {
    private LayoutHelper() {
    }

    public static JPanel buildGridLayoutFor(Iterable<Input> inputs) {
        return LayoutHelper.addToPanel((JPanel)new GridBagLayoutPanel(), (LayoutStrategy)new StringGridBagLayoutStrategy(), inputs);
    }

    public static JPanel buildGridLayoutFor(Input ... inputs) {
        return LayoutHelper.buildGridLayoutFor(Arrays.asList(inputs));
    }

    public static JPanel buildPanelFor(LayoutSpecification layoutSpecification, Iterable<Input> inputs) {
        JPanel result = new JPanel(layoutSpecification.getLayoutManager());
        return LayoutHelper.addToPanel(result, layoutSpecification.getStrategy(), inputs);
    }

    public static JPanel buildPanelFor(LayoutSpecification layoutSpecification, Input ... inputs) {
        JPanel result = new JPanel(layoutSpecification.getLayoutManager());
        return LayoutHelper.addToPanel(result, layoutSpecification.getStrategy(), inputs);
    }

    public static JPanel addToPanel(JPanel panel, LayoutStrategy layoutStrategy, Input ... inputs) {
        return LayoutHelper.addToPanel(panel, layoutStrategy, Arrays.asList(inputs));
    }

    public static JPanel addToPanel(JPanel panel, LayoutStrategy layoutStrategy, Iterable<Input> inputs) {
        for (Input input : inputs) {
            input.addToPanel(panel, layoutStrategy);
        }
        return panel;
    }
}

