/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.helper;

import com.schneide.base.input.helper.LayoutHelper;
import com.schneide.base.input.inputs.InputFactory;
import com.schneide.base.input.inputs.generic.Input;
import com.schneide.base.input.inputs.layout.LayoutStrategy;
import com.schneide.base.input.types.generic.Value;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;

public final class DefaultInputLayoutHelper {
    private DefaultInputLayoutHelper() {
    }

    public static JPanel buildGridLayoutFor(InputFactory factory, Value ... values) {
        return DefaultInputLayoutHelper.buildGridLayoutFor(Arrays.asList(values), factory);
    }

    public static JPanel buildGridLayoutFor(Iterable<Value> values, InputFactory factory) {
        return LayoutHelper.buildGridLayoutFor(DefaultInputLayoutHelper.createDefaultInputsFor(values, factory));
    }

    public static Iterable<Input> createDefaultInputsFor(Iterable<Value> values, InputFactory factory) {
        ArrayList<Input> inputList = new ArrayList<Input>();
        for (Value value : values) {
            inputList.add(value.createNaturalInput(factory));
        }
        return inputList;
    }

    public static JPanel addToPanel(JPanel panel, LayoutStrategy layoutStrategy, InputFactory factory, Value ... values) {
        return DefaultInputLayoutHelper.addToPanel(panel, layoutStrategy, Arrays.asList(values), factory);
    }

    public static JPanel addToPanel(JPanel panel, LayoutStrategy layoutStrategy, Iterable<Value> values, InputFactory factory) {
        return LayoutHelper.addToPanel(panel, layoutStrategy, DefaultInputLayoutHelper.createDefaultInputsFor(values, factory));
    }
}

