/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.datatypes;

import com.schneide.base.input.datatypes.EmailFormatException;
import com.schneide.base.input.i18n.Localisation;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmailAddress {
    private static final String THE_AT = "@";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$");
    private final String recipientName;
    private final String recipientDomain;

    public EmailAddress(String address) throws EmailFormatException {
        if (!EmailAddress.isValidString(address)) {
            throw new EmailFormatException(Localisation.getLocalizedString("emailaddress.error.validAdress"));
        }
        StringTokenizer tokenizer = new StringTokenizer(address, THE_AT);
        this.recipientName = tokenizer.nextToken();
        this.recipientDomain = tokenizer.nextToken();
    }

    public EmailAddress(String name, String domain) throws EmailFormatException {
        if (name == null || name.length() < 1 || domain == null || domain.length() < 4) {
            throw new EmailFormatException(Localisation.getLocalizedString("emailaddress.error.failedCreation"));
        }
        this.recipientName = name;
        this.recipientDomain = domain;
        String resultingAddress = this.getAddress();
        if (!EmailAddress.isValidString(resultingAddress)) {
            throw new EmailFormatException(Localisation.getLocalizedString("emailaddress.error.validAdress"));
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getName());
        result.append(THE_AT);
        result.append(this.getDomain());
        return result.toString();
    }

    public String getAddress() {
        return this.toString();
    }

    public static boolean isValidString(String address) {
        if (null == address) {
            return false;
        }
        Matcher matcher = EMAIL_PATTERN.matcher(address);
        return matcher.matches();
    }

    public String getDomain() {
        return this.recipientDomain;
    }

    public String getName() {
        return this.recipientName;
    }
}

