/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.input.datatypes;

import com.schneide.base.input.datatypes.ValueBound;
import com.schneide.base.input.i18n.Localisation;
import com.schneide.base.text.transformation.Embrace;

public class DoubleValueRange
implements ValueBound {
    public static final double LOWEST_BOUND = -1.7976931348623157E308;
    public static final double UPMOST_BOUND = Double.MAX_VALUE;
    public static final DoubleValueRange DEFAULT_RANGE = new DoubleValueRange(-1.7976931348623157E308, Double.MAX_VALUE);
    private final double lowerBound;
    private final double upperBound;

    public static DoubleValueRange fullBounds(double low, double high) {
        return new DoubleValueRange(low, high);
    }

    public static DoubleValueRange lowBound(double low) {
        return new DoubleValueRange(low);
    }

    public static DoubleValueRange highBound(double high) {
        return new DoubleValueRange(DEFAULT_RANGE.getLowerBound(), high);
    }

    public static DoubleValueRange zeroToBound(double high) {
        return new DoubleValueRange(0.0, high);
    }

    public DoubleValueRange() {
        this(DEFAULT_RANGE.getLowerBound(), DEFAULT_RANGE.getUpperBound());
    }

    public DoubleValueRange(double lowerBound) {
        this(lowerBound, DEFAULT_RANGE.getUpperBound());
    }

    public DoubleValueRange(double lowerBound, double upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public boolean isValueInRange(Double value) {
        if (null == value) {
            return false;
        }
        return value >= this.getLowerBound() && value <= this.getUpperBound();
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public boolean hasLowerRestriction() {
        return this.getLowerBound() > -1.7976931348623157E308;
    }

    public boolean hasUpperRestriction() {
        return this.getUpperBound() < Double.MAX_VALUE;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getLowerBound());
        buffer.append("; ");
        buffer.append(this.getUpperBound());
        return Embrace.withAngleBrackets(buffer.toString());
    }

    @Override
    public String getDescription() {
        return this.getIntuitiveDescription();
    }

    public String getIntuitiveDescription() {
        StringBuffer result = new StringBuffer();
        if (this.hasLowerRestriction()) {
            if (this.hasUpperRestriction()) {
                this.stuffBufferWith(result, "valuerange.double.from");
            } else {
                this.stuffBufferWith(result, "valuerange.double.ex");
            }
            result.append(this.getLowerBound());
        }
        if (this.hasUpperRestriction()) {
            this.stuffBufferWith(result, "valuerange.double.to");
            result.append(this.getUpperBound());
        }
        return result.toString();
    }

    private void stuffBufferWith(StringBuffer result, String localizationKey) {
        result.append(" ");
        result.append(Localisation.getLocalizedString(localizationKey));
        result.append(" ");
    }

    public String getFullDescription() {
        StringBuffer result = new StringBuffer();
        this.stuffBufferWith(result, "valuerange.double.from");
        result.append(this.getLowerBound());
        this.stuffBufferWith(result, "valuerange.double.to");
        result.append(this.getUpperBound());
        return result.toString();
    }
}

