/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.i18n.implementation;

import com.schneide.base.datatypes.collections.ArrayUtil;
import com.schneide.base.i18n.missing.MissingI18NEntryHandler;
import com.schneide.base.i18n.model.TextualContent;
import com.schneide.base.io.encoding.Encoding;
import com.schneide.base.io.file.FileLocator;
import com.schneide.base.system.Base;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropertyFileBasedTextualContent
implements TextualContent {
    private final File[] propertyFiles;
    private Properties[] properties;
    private final Map<String, String> keyCache;
    private final List<MissingI18NEntryHandler> missHandlers = new ArrayList<MissingI18NEntryHandler>();

    public PropertyFileBasedTextualContent(String ... propertyFilePathes) {
        this(FileLocator.getAllOccurrencesOf(propertyFilePathes));
    }

    public PropertyFileBasedTextualContent(File ... propertyFiles) {
        this.propertyFiles = ArrayUtil.copy(propertyFiles);
        this.keyCache = new HashMap<String, String>();
        this.reload();
    }

    @Override
    public void reload() {
        this.clearCache();
        this.properties = PropertyFileBasedTextualContent.loadProperties(this.propertyFiles);
    }

    @Override
    public void clearCache() {
        this.keyCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMissHandler(MissingI18NEntryHandler missHandler) {
        if (missHandler != null) {
            List<MissingI18NEntryHandler> list = this.missHandlers;
            synchronized (list) {
                this.missHandlers.add(missHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMissHandler(MissingI18NEntryHandler missHandler) {
        if (missHandler != null) {
            List<MissingI18NEntryHandler> list = this.missHandlers;
            synchronized (list) {
                this.missHandlers.remove(missHandler);
            }
        }
    }

    private static Properties[] loadProperties(File ... files) {
        ArrayList<Properties> result = new ArrayList<Properties>();
        for (File element : files) {
            try {
                result.add(PropertyFileBasedTextualContent.loadProperties(element));
            }
            catch (IOException e) {
                Base.getLogger(PropertyFileBasedTextualContent.class).error("Internationalisierungsdatei nicht geladen.", e);
            }
        }
        return result.toArray(new Properties[result.size()]);
    }

    private static Properties loadProperties(File instance) throws IOException {
        if (instance.exists() && instance.isFile() && instance.canRead()) {
            Properties properties = new Properties();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(instance), Encoding.utf8()));){
                properties.load(reader);
            }
            return properties;
        }
        throw new IOException("Fehler beim Zugriff auf Datei " + String.valueOf(instance));
    }

    @Override
    public boolean hasTextFor(String key) {
        return null != this.regularTextLookupFor(key);
    }

    @Override
    public String getText(String key) {
        String result = this.regularTextLookupFor(key);
        if (null == result) {
            result = this.missingTextReplacementLookupFor(key);
        }
        return result;
    }

    private String regularTextLookupFor(String key) {
        if (this.keyCache.containsKey(key)) {
            return this.keyCache.get(key);
        }
        String result = this.findTextForKey(key);
        this.keyCache.put(key, result);
        return result;
    }

    private String missingTextReplacementLookupFor(String key) {
        String result = this.getValueForAbsentKey(key);
        this.keyCache.put(key, result);
        return result;
    }

    private Properties[] getProperties() {
        return this.properties;
    }

    private String findTextForKey(String key) {
        Properties[] currentProperties;
        for (Properties element : currentProperties = this.getProperties()) {
            if (!element.containsKey(key)) continue;
            return element.getProperty(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getValueForAbsentKey(String key) {
        String result = key;
        List<MissingI18NEntryHandler> list = this.missHandlers;
        synchronized (list) {
            for (MissingI18NEntryHandler missingI18NEntryHandler : this.missHandlers) {
                result = missingI18NEntryHandler.informMissingEntry(key);
            }
        }
        return result;
    }

    @Override
    public String getParametrizedText(String key, Object ... parameters) {
        String unformatted = this.getText(key);
        return MessageFormat.format(this.doubleAllSingleQuotes(unformatted), parameters);
    }

    private String doubleAllSingleQuotes(String text) {
        if (null == text) {
            return "";
        }
        return text.replace("'", "''");
    }
}

