/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.i18n.implementation;

import com.schneide.base.datatypes.collections.ArrayUtil;
import com.schneide.base.i18n.model.LocalizationResource;
import com.schneide.base.io.file.FileLocator;
import com.schneide.base.properties.ConfigurationSection;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.StringProperty;
import com.schneide.base.properties.applicationLevel.StringsProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class FileLocalizationResource
implements LocalizationResource {
    private final File[] resourceFiles;
    private final String fallbackLocale;

    public FileLocalizationResource(File ... files) {
        this((String)null, files);
    }

    public FileLocalizationResource(String fallbackLocale, File ... files) {
        this.fallbackLocale = fallbackLocale;
        this.resourceFiles = files;
    }

    public FileLocalizationResource(ConfigurationSection section) {
        this(FileLocalizationResource.extractFallbackLocaleFor(section), FileLocalizationResource.extractFilesFor(section));
    }

    public static FileLocalizationResource createFor(IResourceProvider ... providers) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (IResourceProvider provider : providers) {
            fileList.addAll(Arrays.asList(provider.getFiles()));
        }
        return new FileLocalizationResource(fileList.toArray(new File[fileList.size()]));
    }

    private static String extractFallbackLocaleFor(ConfigurationSection section) {
        return StringProperty.buildConfigured(section, new PropertyReference("fallback")).getValue();
    }

    private static File[] extractFilesFor(ConfigurationSection section) {
        String[] directories;
        ArrayList<File> resultList = new ArrayList<File>();
        String[] paths = StringsProperty.buildConfigured(section, PropertyReference.forKey("file")).getValues();
        if (ArrayUtil.hasContent(paths)) {
            for (String element : paths) {
                resultList.add(FileLocator.getFile(element));
            }
        }
        if (ArrayUtil.hasContent(directories = StringsProperty.buildConfigured(section, PropertyReference.forKey("directory")).getValues())) {
            for (String element : directories) {
                File[] files = FileLocator.getAllContentOf(element);
                resultList.addAll(Arrays.asList(files));
            }
        }
        return resultList.toArray(new File[resultList.size()]);
    }

    @Override
    public String getFallbackLocale() {
        return this.fallbackLocale;
    }

    @Override
    public File[] getFiles() {
        return this.resourceFiles;
    }

    @Override
    public boolean hasFallbackLocale() {
        return null != this.getFallbackLocale();
    }

    public static interface IResourceProvider {
        public File[] getFiles();
    }

    public static class ResourceDirectory
    extends AbstractResource {
        public ResourceDirectory(String path) {
            super(path);
        }

        @Override
        public File[] getFiles() {
            return FileLocator.getAllContentOf(this.getPath());
        }
    }

    public static class ResourceFile
    extends AbstractResource {
        public ResourceFile(String path) {
            super(path);
        }

        @Override
        public File[] getFiles() {
            return new File[]{FileLocator.getFile(this.getPath())};
        }
    }

    private static abstract class AbstractResource
    implements IResourceProvider {
        private final String path;

        public AbstractResource(String path) {
            this.path = path;
        }

        protected String getPath() {
            return this.path;
        }
    }
}

