/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.i18n.implementation;

import com.schneide.base.i18n.implementation.FileLocalizationResource;
import com.schneide.base.i18n.model.I18NConfiguration;
import com.schneide.base.i18n.model.LocalizationResource;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.ConfigurationSection;
import com.schneide.base.properties.applicationLevel.BooleanProperty;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.StringProperty;
import java.io.File;

public class FileI18NConfiguration
extends LoggedObject
implements I18NConfiguration {
    private static final String SECTIONIDENTIFIER_BUNDLE = "bundle";
    private final Configuration configuration;

    public FileI18NConfiguration(VirtualFile configFile) {
        this.configuration = new Configuration(configFile);
    }

    private Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getForcedLocale() {
        return StringProperty.buildConfigured(this.getConfiguration(), PropertyReference.forKey("forced.locale")).getValue();
    }

    @Override
    public LocalizationResource getResource(String locale) throws IllegalArgumentException {
        ConfigurationSection section = this.getConfiguration().getSection(locale);
        return new FileLocalizationResource(section);
    }

    @Override
    public boolean hasResourceFor(String locale) {
        return this.getConfiguration().hasSection(SECTIONIDENTIFIER_BUNDLE, locale);
    }

    @Override
    public boolean isForcedLocaleEnabled() {
        return BooleanProperty.buildConfigured(this.getConfiguration(), PropertyReference.forKey("forced.locale.enabled")).getValue();
    }

    @Override
    public File getI18NMissingLogFile() {
        return new File(StringProperty.buildConfigured(this.getConfiguration(), PropertyReference.forKey("missing.i18n.logfile"), "logs/missingI18N.log").getValue());
    }

    @Override
    public boolean getMissingI18NDateState() {
        return BooleanProperty.buildConfigured(this.getConfiguration(), PropertyReference.forKey("missing.i18n.timestamp.enabled"), true).getValue();
    }
}

