/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.i18n;

import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NResolvable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class I18NText
implements I18NResolvable {
    private final I18NKey key;
    private final List<Object> parameters;

    public I18NText(String i18NKey, Object ... parameters) {
        this(new I18NKey(i18NKey), parameters);
    }

    public I18NText(I18NKey key, Object ... parameters) {
        this(key, Arrays.asList(parameters));
    }

    public I18NText(I18NKey key, Iterable<Object> parameters) {
        this.key = key;
        this.parameters = new ArrayList<Object>();
        CollectionUtil.addAll(this.parameters, parameters);
    }

    @Override
    public boolean isI18Ned() {
        return true;
    }

    @Override
    public Iterable<Object> getParameters() {
        return new ArrayList<Object>(this.parameters);
    }

    private Object[] getParametersAsArray() {
        return this.parameters.toArray(new Object[this.parameters.size()]);
    }

    @Override
    public I18NKey getI18NKey() {
        return this.key;
    }

    @Override
    public String resolvedText() {
        return this.getI18NKey().getResolvedText(this.getParametersAsArray());
    }

    @Override
    public I18NResolvable withKeyPart(String keyPart) {
        return new I18NText(I18NKey.appendKeyParts(this.getI18NKey().getKey(), keyPart), this.getParametersAsArray());
    }

    @Override
    public boolean isResolvableWithoutFallback() {
        return this.getI18NKey().isResolvableWithoutFallback();
    }

    public String toString() {
        return this.resolvedText();
    }
}

