/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.i18n;

import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NResolvable;
import java.text.MessageFormat;
import java.util.Arrays;

public class DirectText
implements I18NResolvable {
    private final String text;
    private final Object[] parameters;

    public DirectText(String text) {
        this(text, new Object[0]);
    }

    public DirectText(String text, Object ... parameters) {
        this.text = text;
        this.parameters = parameters;
    }

    @Override
    public boolean isI18Ned() {
        return false;
    }

    @Override
    public I18NResolvable withKeyPart(String keyPart) {
        return this;
    }

    @Override
    public I18NKey getI18NKey() {
        return new I18NKey(this.text);
    }

    public String text() {
        return this.resolvedText();
    }

    @Override
    public String resolvedText() {
        if (null == this.text) {
            return "";
        }
        return MessageFormat.format(this.doubleAllSingleQuotes(this.text), this.parameters);
    }

    public DirectText withNewParameters(Object ... newParameters) {
        return new DirectText(this.text, newParameters);
    }

    private String doubleAllSingleQuotes(String s) {
        return s.replace("'", "''");
    }

    @Override
    public Iterable<Object> getParameters() {
        return Arrays.asList(this.parameters);
    }

    @Override
    public boolean isResolvableWithoutFallback() {
        return true;
    }

    public String toString() {
        return this.resolvedText();
    }
}

