/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.i18n;

import com.schneide.base.i18n.implementation.PropertyFileBasedTextualContent;
import com.schneide.base.i18n.missing.LoggedMissingI18NEntryHandler;
import com.schneide.base.i18n.missing.PersistedMissingI18NEntryHandler;
import com.schneide.base.i18n.model.I18NConfiguration;
import com.schneide.base.i18n.model.LocalizationResource;
import com.schneide.base.io.file.FileUtil;
import com.schneide.base.system.Base;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public final class DefaultSchneideI18NSetup {
    private DefaultSchneideI18NSetup() {
    }

    public static void setupFor(I18NConfiguration i18nConfig) {
        String locale = Locale.getDefault().toString();
        if (i18nConfig.isForcedLocaleEnabled()) {
            locale = i18nConfig.getForcedLocale();
        }
        LocalizationResource resource = i18nConfig.getResource(locale);
        PropertyFileBasedTextualContent textualContent = new PropertyFileBasedTextualContent(resource.getFiles());
        textualContent.addMissHandler(new LoggedMissingI18NEntryHandler());
        try {
            File logFile = i18nConfig.getI18NMissingLogFile();
            FileUtil.ensureDirectoryStructureForFile(logFile);
            textualContent.addMissHandler(new PersistedMissingI18NEntryHandler(logFile, i18nConfig.getMissingI18NDateState()));
        }
        catch (IOException e) {
            Base.getLogger(DefaultSchneideI18NSetup.class).error("Cannot use the 'Missing I18N'-logfile.", e);
        }
        Base.setCurrentTextContent(textualContent);
    }
}

