/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.gui.support;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;

public class WidgetCollector {
    public static final WidgetCriteria ONLY_SWING = component -> {
        if (component instanceof JComponent) {
            return true;
        }
        return component instanceof RootPaneContainer;
    };
    private final List<WidgetCriteria> criterias = new ArrayList<WidgetCriteria>();

    public WidgetCollector(WidgetCriteria ... criterias) {
        Collections.addAll(this.criterias, criterias);
    }

    public Iterable<Component> collectFrom(Container root) {
        if (null == root) {
            return Collections.emptyList();
        }
        return this.collect(this.widgetsIn(root), this.andPutThemInto(new ArrayList<Component>()));
    }

    protected List<Component> collect(Container current, List<Component> result) {
        for (Component component : current.getComponents()) {
            if (this.isAcceptedByCriterias(component)) {
                result.add(component);
            }
            if (!(component instanceof Container)) continue;
            this.collect((Container)component, result);
        }
        return result;
    }

    protected boolean isAcceptedByCriterias(Component component) {
        for (WidgetCriteria criteria : this.criterias) {
            if (criteria.accepts(component)) continue;
            return false;
        }
        return true;
    }

    private List<Component> andPutThemInto(ArrayList<Component> arrayList) {
        return arrayList;
    }

    private Container widgetsIn(Container root) {
        return root;
    }

    public static interface WidgetCriteria {
        public boolean accepts(Component var1);
    }
}

